package com.biz.crm.dms.business.costpool.capital.local.utils;

import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;

/**
 * @description: 资金调整util
 * @author: rentao
 * @date: 2021/12/13 20:04
 */
public class CapitalOperationTypeUtil {


  /**
   * 调整资金池验证（充值）
   *
   * @param costPoolCapitalDto
   */
  public static void validateRechargeCostPoolCapitalDto(CostPoolCapitalDto costPoolCapitalDto) {
    Validate.notNull(costPoolCapitalDto, "资金调整信息不能为空");
    Validate.notNull(costPoolCapitalDto.getCustomerCode(), "资金客户编码不能为空");
    Validate.notNull(costPoolCapitalDto.getAdjustMoney(), "充值金额不能为空");
    Validate.isTrue(costPoolCapitalDto.getAdjustMoney().compareTo(BigDecimal.ZERO) > 0, "客户充值金额不能小于零。");
  }

  /**
   * 调整资金池验证（通用）
   *
   * @param costPoolCapitalDto
   */
  public static void validateCostPoolCapitalDto(CostPoolCapitalDto costPoolCapitalDto) {
    Validate.notNull(costPoolCapitalDto, "资金调整信息不能为空");
    Validate.notNull(costPoolCapitalDto.getCustomerCode(), "资金客户编码不能为空");
    Validate.notNull(costPoolCapitalDto.getAdjustMoney(), "操作金额不能为空");
  }

}
