/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.capital.local.constant.CapitalConstant;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalPageDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u91d1\u7ba1\u7406: Capital : \u8d44\u91d1\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/v1/capital/capital"})
public class CapitalController {
    private static final Logger log = LoggerFactory.getLogger(CapitalController.class);
    @Autowired(required=false)
    private CapitalService capitalService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Capital>> findByConditions(@PageableDefault(value=50) Pageable pageable, CapitalPageDto capitalDto) {
        return Result.ok(this.capitalService.findByConditions(pageable, capitalDto));
    }

    @ApiOperation(value="\u6839\u636e\u4e3b\u952eid\u67e5\u8be2")
    @GetMapping(value={"/findById"})
    public Result<Capital> findById(@RequestParam String id) {
        return Result.ok((Object)((Object)this.capitalService.findById(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5ba2\u6237\u8d44\u91d1\u6c60\u8c03\u6574")
    @PatchMapping(value={"handleAdjust"})
    public Result<?> handleAdjust(@RequestBody CostPoolCapitalDto costPoolCapitalDto) {
        String lockKey = String.format("capital:change:lock:%s", TenantUtils.getTenantCode());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CapitalConstant.CAPITAL_TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.capitalService.handleAdjust(costPoolCapitalDto);
            Result result = Result.ok();
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }
}

