/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlowFile;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowFileRepository;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowRepository;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowCustomerDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustGroupEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.service.CapitalFlowVoService;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalFlowFileVo;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalFlowVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class CapitalFlowVoServiceImpl
implements CapitalFlowVoService {
    private static final Logger log = LoggerFactory.getLogger(CapitalFlowVoServiceImpl.class);
    @Autowired(required=false)
    private CapitalFlowRepository capitalFlowRepository;
    @Autowired(required=false)
    private CapitalFlowFileRepository capitalFlowFileRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public CapitalFlowVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CapitalFlow capitalFlow = (CapitalFlow)((Object)this.capitalFlowRepository.getById((Serializable)((Object)id)));
        if (capitalFlow == null) {
            return null;
        }
        CapitalFlowVo vo = (CapitalFlowVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)capitalFlow, CapitalFlowVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<CapitalFlowFile> capitalFlowFiles = this.capitalFlowFileRepository.findByFlowNo(vo.getFlowNo());
        if (CollectionUtils.isNotEmpty(capitalFlowFiles)) {
            List capitalFlowFileVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(capitalFlowFiles, CapitalFlowFile.class, CapitalFlowFileVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setCapitalFlowFileVos(capitalFlowFileVos);
        }
        return vo;
    }

    public CapitalFlowVo findDetailsByFlowNo(String flowNo) {
        if (StringUtils.isBlank((CharSequence)flowNo)) {
            return null;
        }
        CapitalFlow capitalFlow = this.capitalFlowRepository.findByFlowNo(flowNo);
        if (capitalFlow == null) {
            return null;
        }
        CapitalFlowVo vo = (CapitalFlowVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)capitalFlow, CapitalFlowVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<CapitalFlowFile> capitalFlowFiles = this.capitalFlowFileRepository.findByFlowNo(vo.getFlowNo());
        if (CollectionUtils.isNotEmpty(capitalFlowFiles)) {
            List capitalFlowFileVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(capitalFlowFiles, CapitalFlowFile.class, CapitalFlowFileVo.class, HashSet.class, ArrayList.class, new String[0]);
            vo.setCapitalFlowFileVos(capitalFlowFileVos);
        }
        return vo;
    }

    public Page<CapitalFlowVo> findByCapitalFlowCustomerDto(Pageable pageable, CapitalFlowCustomerDto capitalFlowCustomerDto) {
        String customerCode = capitalFlowCustomerDto.getCustomerCode();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            Page pageResult = new Page(0L, 0L, 0L);
            return pageResult;
        }
        capitalFlowCustomerDto.setCustomerCode(customerCode);
        Validate.notBlank((CharSequence)capitalFlowCustomerDto.getGroup(), (String)"\u4e0a\u8d26/\u4f7f\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CapitalAdjustGroupEnum capitalAdjustGroupEnum = CapitalAdjustGroupEnum.getByKey((String)capitalFlowCustomerDto.getGroup());
        Validate.isTrue((!ObjectUtils.isEmpty((Object)capitalAdjustGroupEnum) ? 1 : 0) != 0, (String)"\u4e0a\u8d26/\u4f7f\u7528\u6807\u8bc6\u9519\u8bef", (Object[])new Object[0]);
        List adjustTypeList = CapitalAdjustTypeEnum.getDictCodeByGroupEnum((CapitalAdjustGroupEnum)capitalAdjustGroupEnum);
        capitalFlowCustomerDto.setAdjustTypeList(adjustTypeList);
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        capitalFlowCustomerDto.setTenantCode(TenantUtils.getTenantCode());
        Page<CapitalFlow> entityResult = this.capitalFlowRepository.findByCapitalFlowCustomerDto((Page<CapitalFlow>)page, capitalFlowCustomerDto);
        Page pageResult = new Page(entityResult.getCurrent(), entityResult.getSize(), entityResult.getTotal());
        if (CollectionUtils.isEmpty((Collection)entityResult.getRecords())) {
            return pageResult;
        }
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityResult.getRecords(), CapitalFlow.class, CapitalFlowVo.class, HashSet.class, ArrayList.class, new String[0]));
        pageResult.setRecords((List)list);
        return pageResult;
    }

    public List<CapitalFlowVo> findByCapitalFlowCustomerDto(CapitalFlowCustomerDto capitalFlowCustomerDto) {
        capitalFlowCustomerDto.setTenantCode(TenantUtils.getTenantCode());
        List<CapitalFlow> entityResult = this.capitalFlowRepository.findByCapitalFlowCustomerDto(capitalFlowCustomerDto);
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(entityResult, CapitalFlow.class, CapitalFlowVo.class, HashSet.class, ArrayList.class, new String[0]));
        return list;
    }
}

