/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.strategy.CapitalOperationTypeStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CapitalOperationTypeInitStrategy
implements CapitalOperationTypeStrategy {
    @Autowired(required=false)
    private CapitalService capitalService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public String getOperationTypeGroup() {
        return CapitalAdjustTypeEnum.INIT.getKey();
    }

    public String getOperationTypeGroupName() {
        return CapitalAdjustTypeEnum.INIT.getValue();
    }

    @Transactional
    public void onSaveCapitalInfos(CostPoolCapitalDto costPoolCapitalDto) {
        CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, costPoolCapitalDto.getCustomerCode());
        Validate.notNull((Object)customerVo, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Capital capital = this.capitalService.findByCustomerCode(costPoolCapitalDto.getCustomerCode());
        Validate.isTrue((boolean)Objects.isNull((Object)capital), (String)"\u5df2\u6709\u5bf9\u5e94\u5ba2\u6237\u8d44\u91d1\u5b58\u5728\u4e0d\u80fd\u521d\u59cb\u5316\u8d44\u91d1\u6c60\uff01", (Object[])new Object[0]);
        CapitalDto capitalDto = this.transformDataAdd(costPoolCapitalDto, customerVo);
        this.capitalService.create(capitalDto);
    }

    public BooleanEnum getActiveType() {
        return BooleanEnum.TRUE;
    }

    public BooleanEnum getAmanagementType() {
        return BooleanEnum.TRUE;
    }

    public BooleanEnum getInitType() {
        return BooleanEnum.TRUE;
    }

    private CapitalDto transformDataAdd(CostPoolCapitalDto costPoolCapitalDto, CustomerVo customerVo) {
        CapitalDto capitalDto = new CapitalDto();
        capitalDto.setCusOrgCode(customerVo.getCustomerOrgCode());
        capitalDto.setCusOrgName(customerVo.getCustomerOrgName());
        capitalDto.setCustomerCode(customerVo.getCustomerCode());
        capitalDto.setCustomerName(customerVo.getCustomerName());
        capitalDto.setCapitalCode((String)this.generateCodeService.generateCode("KHZJ", 1).get(0));
        capitalDto.setTenantCode(TenantUtils.getTenantCode());
        capitalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        capitalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        capitalDto.setFrozeMoney(BigDecimal.ZERO);
        capitalDto.setUseMoney(BigDecimal.ZERO);
        capitalDto.setCapitalAbleTotal(costPoolCapitalDto.getAdjustMoney());
        capitalDto.setCapitalTotal(costPoolCapitalDto.getAdjustMoney());
        capitalDto.setAdjustMoney(costPoolCapitalDto.getAdjustMoney());
        capitalDto.setAdjustType(CapitalAdjustTypeEnum.INIT.getKey());
        capitalDto.setAdjustTypeName(CapitalAdjustTypeEnum.INIT.getValue());
        if (StringUtils.isNotBlank((CharSequence)costPoolCapitalDto.getBillNo())) {
            capitalDto.setBillNo(costPoolCapitalDto.getBillNo());
            capitalDto.setBillType(costPoolCapitalDto.getBillType());
        } else {
            capitalDto.setBillNo(costPoolCapitalDto.getFromCode());
            capitalDto.setBillType(costPoolCapitalDto.getFromDesc());
        }
        return capitalDto;
    }
}

