/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.local.utils.CapitalOperationTypeUtil;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.strategy.CapitalOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CapitalOperationTypeOccupyReleaseStrategy
implements CapitalOperationTypeStrategy {
    @Autowired(required=false)
    private CapitalService capitalService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getOperationTypeGroup() {
        return CapitalAdjustTypeEnum.OCCUPY_RELEASE.getKey();
    }

    public String getOperationTypeGroupName() {
        return CapitalAdjustTypeEnum.OCCUPY_RELEASE.getValue();
    }

    @Transactional
    public void onSaveCapitalInfos(CostPoolCapitalDto costPoolCapitalDto) {
        CapitalOperationTypeUtil.validateCostPoolCapitalDto(costPoolCapitalDto);
        Capital capital = this.capitalService.findByCustomerCode(costPoolCapitalDto.getCustomerCode());
        Validate.notNull((Object)((Object)capital), (String)"\u5bf9\u5e94\u5ba2\u6237\u8d44\u91d1\u4e0d\u5b58\u5728\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        BigDecimal adjustMoney = costPoolCapitalDto.getAdjustMoney();
        Validate.isTrue((adjustMoney.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)"\u5360\u7528/\u91ca\u653e\u989d\u5ea6\u4e0d\u80fd0", (Object[])new Object[0]);
        CapitalDto capitalDto = this.transformDataUpdate(capital, costPoolCapitalDto);
        this.capitalService.create(capitalDto);
    }

    public BooleanEnum getActiveType() {
        return BooleanEnum.TRUE;
    }

    public BooleanEnum getAmanagementType() {
        return BooleanEnum.FALSE;
    }

    public BooleanEnum getInitType() {
        return BooleanEnum.FALSE;
    }

    private CapitalDto transformDataUpdate(Capital capital, CostPoolCapitalDto costPoolCapitalDto) {
        CapitalDto capitalDto = (CapitalDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)capital, CapitalDto.class, HashSet.class, ArrayList.class, new String[0]);
        BigDecimal capitalAbleTotalOld = capital.getCapitalAbleTotal();
        BigDecimal occupyMoneyOld = capital.getOccupyMoney();
        BigDecimal adjustMoney = costPoolCapitalDto.getAdjustMoney();
        BigDecimal occupyMoneyNew = occupyMoneyOld.subtract(adjustMoney);
        Validate.notNull((Object)occupyMoneyNew, (String)"\u5f53\u524d\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (Object[])new Object[0]);
        Validate.isTrue((occupyMoneyNew.compareTo(occupyMoneyOld) != 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u540e\u4e0d\u80fd\u7b49\u4e8e\u8c03\u6574\u524d\u989d\u5ea6\u3002", (Object[])new Object[0]);
        Validate.isTrue((occupyMoneyNew.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8c03\u6574\u540e\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6\u3002", (Object[])new Object[0]);
        BigDecimal capitalAbleTotalNew = capitalAbleTotalOld.add(adjustMoney);
        Validate.isTrue((capitalAbleTotalNew.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u53ef\u7528\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6\u3002", (Object[])new Object[0]);
        capitalDto.setCapitalAbleTotal(capitalAbleTotalNew);
        capitalDto.setOccupyMoney(occupyMoneyNew);
        capitalDto.setAdjustMoney(adjustMoney);
        capitalDto.setAdjustType(costPoolCapitalDto.getAdjustType());
        capitalDto.setAdjustTypeName(CapitalAdjustTypeEnum.OCCUPY_RELEASE.getValue());
        capitalDto.setCapitalFlowFileDtos(costPoolCapitalDto.getCapitalFlowFileDtos());
        capitalDto.setCreateTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)costPoolCapitalDto.getBillNo())) {
            capitalDto.setBillNo(costPoolCapitalDto.getBillNo());
            capitalDto.setBillType(costPoolCapitalDto.getBillType());
        } else {
            capitalDto.setBillNo(costPoolCapitalDto.getFromCode());
            capitalDto.setBillType(costPoolCapitalDto.getFromDesc());
        }
        return capitalDto;
    }
}

