package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCustomerVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryCustomerPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCustomerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授信管理: CreditCustomerVo: 授信客户信息
 *
 * @author ning.zhang
 * @date 2021/12/20
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/creditCustomer")
@Api(tags = "授信管理: CreditCustomerVo: 授信客户信息")
public class CreditCustomerVoController {

  @Autowired(required = false)
  private CreditCustomerVoService creditCustomerVoService;

  /**
   * 临时授信客户信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditCustomerVo> 临时授信客户分页信息
   */
  @ApiOperation(value = "临时授信客户信息分页列表")
  @GetMapping("/findByCreditTemporaryCustomerPageDto")
  public Result<Page<CreditCustomerVo>> findByCreditTemporaryCustomerPageDto(@PageableDefault(50) Pageable pageable,
                                                                             @ApiParam(name = "CompanyInformationPageDto", value = "分页Dto") CreditTemporaryCustomerPageDto dto) {
    try {
      return Result.ok(this.creditCustomerVoService.findByCreditTemporaryCustomerPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
