package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFreezeService;
import com.biz.crm.dms.business.costpool.credit.sdk.constant.CreditConstant;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditFreezeDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

/**
 * 授信管理: CreditFreeze: 授信冻结解冻
 *
 * @author ning.zhang
 * @date 2021/12/20
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/freeze")
@Api(tags = "授信管理: CreditFreeze: 授信冻结解冻")
public class CreditFreezeController {

  @Autowired(required = false)
  private CreditFreezeService creditFreezeService;
  @Autowired(required = false)
  private CreditVoService creditVoService;
  @Autowired(required = false)
  private RedisMutexService redisMutexService;

  /**
   * 新增授信冻结
   *
   * @param dto 参数dto
   * @return 操作结果
   */
  @ApiOperation(value = "新增授信冻结")
  @PostMapping("")
  public Result<?> create(@RequestBody CreditFreezeDto dto) {
    String lockKey = this.creditVoService.buildCashLockKeyByCreditId(dto.getCreditId());
    Validate.isTrue(this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CreditConstant.CREDIT_TRY_LOCK_OUT_TIME)
        ,CreditConstant.CREDIT_LOCK_FAIL_MESSAGE);
    try {
      this.creditFreezeService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(lockKey);
    }
  }
}
