package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWaitWriteOffDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditWaitWriteOffVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWaitWriteOffVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授信管理: CreditWriteOff: 授信核销
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/writeOff")
@Api(tags = "授信管理: CreditWaitWriteOffVo: 授信待核销信息")
public class CreditWaitWriteOffVoController {

  @Autowired(required = false)
  private CreditWaitWriteOffVoService creditWaitWriteOffVoService;

  /**
   * 获取授信待核销信息
   *
   * @param dto 参数dto
   * @return 授信待核销信息
   */
  @ApiOperation(value = "获取授信待核销信息")
  @GetMapping("findByCreditWaitWriteOffDto")
  public Result<CreditWaitWriteOffVo> findByCreditWaitWriteOffDto(@ApiParam(name = "CreditWaitWriteOffDto", value = "参数dto") CreditWaitWriteOffDto dto) {
    try {
      return Result.ok(this.creditWaitWriteOffVoService.findByCreditWaitWriteOffDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
