package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditWriteOffItemService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffItemPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授信管理: CreditWriteOffItem: 授信核销明细信息(核销单据信息)
 *
 * @author ning.zhang
 * @date 2021/12/23
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/writeOffItem")
@Api(tags = "授信管理: CreditWriteOffItem: 授信核销明细信息(核销单据信息)")
public class CreditWriteOffItemController {

  @Autowired(required = false)
  private CreditWriteOffItemService creditWriteOffItemService;

  /**
   * 授信核销明细分页列表(核销单据分页)
   *
   * @param dto 参数dto
   * @return 授信核销分页信息
   */
  @ApiOperation(value = "授信核销明细分页列表(核销单据分页)")
  @GetMapping("findByConditions")
  public Result<Page<CreditWriteOffItemEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "CreditWriteOffItemPageDto", value = "分页Dto") CreditWriteOffItemPageDto dto) {
    try {
      return Result.ok(this.creditWriteOffItemService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
