package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffInfoStatsDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditWriteOffStatsVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffStatsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授信管理:  CreditWriteOffStatsVo: 授信核销明细统计信息
 *
 * @author ning.zhang
 * @date 2021/12/23
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/writeOff")
@Api(tags = "授信管理:  CreditWriteOffStatsVo: 授信核销明细统计信息")
public class CreditWriteOffStatsVoController {

  @Autowired(required = false)
  private CreditWriteOffStatsVoService creditWriteOffStatsVoService;

  /**
   * 获取授信核销明细的统计信息
   *
   * @param dto 参数dto
   * @return 授信核销明细的统计信息
   */
  @ApiOperation(value = "获取授信核销明细的统计信息")
  @GetMapping("findByCreditWriteOffInfoStatsDto")
  public Result<CreditWriteOffStatsVo> findByCreditWriteOffInfoStatsDto(@ApiParam(name = "CreditWriteOffInfoStatsDto", value = "参数dto") CreditWriteOffInfoStatsDto dto) {
    try {
      return Result.ok(this.creditWriteOffStatsVoService.findByCreditWriteOffInfoStatsDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
