package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;

/**
 * 授信资金流水实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditCashFlowEntity", description = "授信资金流水实体类")
@Entity
@TableName("dms_credit_cash_flow")
@Table(name = "dms_credit_cash_flow", indexes = {
    @Index(name = "dms_credit_cash_flow_index1", columnList = "cash_serial_number", unique = true),
    @Index(name = "dms_credit_cash_flow_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_cash_flow_index3", columnList = "adjust_operate_code"),
    @Index(name = "dms_credit_cash_flow_index4", columnList = "adjust_type_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_cash_flow", comment = "授信资金流水表")
public class CreditCashFlowEntity extends TenantOpEntity {

  private static final long serialVersionUID = 4282830834061135503L;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  @Column(name = "cash_serial_number", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金流水号'")
  private String cashSerialNumber;

  /**
   * 调整操作编码
   */
  @ApiModelProperty("调整操作编码")
  @Column(name = "adjust_operate_code", columnDefinition = "VARCHAR(30) COMMENT '调整操作编码'")
  private String adjustOperateCode;

  /**
   * 调整操作名称
   */
  @ApiModelProperty("调整操作名称")
  @Column(name = "adjust_operate_name", columnDefinition = "VARCHAR(80) COMMENT '调整操作名称'")
  private String adjustOperateName;

  /**
   * 调整类型编码
   */
  @ApiModelProperty("调整类型编码")
  @Column(name = "adjust_type_code", columnDefinition = "VARCHAR(30) COMMENT '调整类型编码'")
  private String adjustTypeCode;

  /**
   * 调整类型名称
   */
  @ApiModelProperty("调整类型名称")
  @Column(name = "adjust_type_name", columnDefinition = "VARCHAR(80) COMMENT '调整类型名称'")
  private String adjustTypeName;

  /**
   * 操作金额
   */
  @ApiModelProperty("操作金额")
  @Column(name = "operate_amount", columnDefinition = "decimal(20,4) COMMENT '操作金额'")
  private BigDecimal operateAmount;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 当前长期授信额度
   */
  @ApiModelProperty("当前长期授信额度")
  @Column(name = "long_amount", columnDefinition = "decimal(20,4) COMMENT '操作金额'")
  private BigDecimal longAmount;

  /**
   * 当前长期授信可用余额
   */
  @ApiModelProperty("当前长期授信可用余额")
  @Column(name = "long_can_use_amount", columnDefinition = "decimal(20,4) COMMENT '操作金额'")
  private BigDecimal longCanUseAmount;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Transient
  @TableField(exist = false)
  private String customerName;
}
