package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 授信相关文件实体类
 *
 * @author ning.zhang
 * @date 2021/12/13
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditFileEntity", description = "授信相关文件实体类")
@Entity
@Table(name = "dms_credit_file", indexes = {
    @Index(name = "dms_credit_file_index1", columnList = "business_id"),
    @Index(name = "dms_credit_file_index2", columnList = "tenant_code"),
})
@TableName(value = "dms_credit_file")
@org.hibernate.annotations.Table(appliesTo = "dms_credit_file", comment = "授信相关文件表")
public class CreditFileEntity extends TenantOpEntity {

  private static final long serialVersionUID = -3910332383539141452L;

  /**
   * 文件地址
   */
  @ApiModelProperty(value = "文件地址")
  @Column(name = "file_url", columnDefinition = "VARCHAR(255) COMMENT '文件地址'")
  private String fileUrl;

  /**
   * 文件名称
   */
  @ApiModelProperty(value = "文件名称")
  @Column(name = "file_name", columnDefinition = "VARCHAR(128) COMMENT '文件名称'")
  private String fileName;

  /**
   * 排序
   */
  @ApiModelProperty(value = "排序")
  @Column(name = "sort_num", columnDefinition = "INT(5) COMMENT '排序'")
  private Integer sortNum;

  /**
   * 文件类型(credit:授信主体,creditChange:授信变更,downUpAccount:授信回款上账)
   */
  @ApiModelProperty(value = "文件类型(credit:授信主体,creditChange:授信变更,downUpAccount:授信回款上账)")
  @Column(name = "file_type", columnDefinition = "VARCHAR(30) COMMENT '文件类型(credit:授信主体,creditChange:授信变更,downUpAccount:授信回款上账)'")
  private String fileType;

  /**
   * 相关业务ID(根据文件类型的不同关联不同场景业务表ID)
   */
  @ApiModelProperty(value = "相关业务ID(根据文件类型的不同关联不同场景业务表ID)")
  @Column(name = "business_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '相关业务ID(根据文件类型的不同关联不同场景业务表ID)'")
  private String businessId;
}
