package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 授信冻结实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditFreezeEntity", description = "授信冻结实体类")
@Entity
@TableName("dms_credit_freeze")
@Table(name = "dms_credit_freeze", indexes = {
    @Index(name = "dms_credit_freeze_index1", columnList = "credit_id"),
    @Index(name = "dms_credit_freeze_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_freeze_index3", columnList = "cash_serial_number"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_freeze", comment = "授信冻结表")
public class CreditFreezeEntity extends TenantOpEntity {

  private static final long serialVersionUID = 37834230469966242L;

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  @Column(name = "credit_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '授信ID'")
  private String creditId;

  /**
   * 冻结额度
   */
  @ApiModelProperty("冻结额度")
  @Column(name = "freeze_amount", columnDefinition = "decimal(20,4) COMMENT '冻结额度'")
  private BigDecimal freezeAmount;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  @Column(name = "cash_serial_number", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金流水号'")
  private String cashSerialNumber;
}
