package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 授信记录实体类
 * <p>
 * 此表用于记录授信和临时授信新增或修改时数据
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditRecordEntity", description = "授信记录实体类")
@Entity
@TableName("dms_credit_record")
@Table(name = "dms_credit_record", indexes = {
    @Index(name = "dms_credit_record_index1", columnList = "credit_id"),
    @Index(name = "dms_credit_record_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_record_index3", columnList = "cash_serial_number"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_record", comment = "授信记录表")
public class CreditRecordEntity extends TenantOpEntity {

  private static final long serialVersionUID = -8219490688919146114L;

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  @Column(name = "credit_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '授信ID'")
  private String creditId;

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  @Column(name = "credit_type", columnDefinition = "VARCHAR(30) COMMENT '授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))'")
  private String creditType;

  /**
   * 变更后授信额度
   */
  @ApiModelProperty("变更后授信额度")
  @Column(name = "credit_amount", columnDefinition = "decimal(20,4) COMMENT '变更后授信额度'")
  private BigDecimal creditAmount;

  /**
   * 变更后授信开始时间
   */
  @ApiModelProperty("变更后授信开始时间")
  @Column(name = "credit_start_time", columnDefinition = "datetime COMMENT '变更后授信开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 变更后授信结束时间
   */
  @ApiModelProperty("变更后授信结束时间")
  @Column(name = "credit_end_time", columnDefinition = "datetime COMMENT '变更后授信结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 变更后还款截止时间
   */
  @ApiModelProperty("变更后还款截止时间")
  @Column(name = "repay_end_time", columnDefinition = "datetime COMMENT '变更后还款截止时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  @Column(name = "cash_serial_number", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金流水号'")
  private String cashSerialNumber;

  /**
   * 文件信息
   */
  @ApiModelProperty("公告文件信息")
  @Transient
  @TableField(exist = false)
  private List<CreditFileEntity> fileList;
}
