package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 授信退款实体类
 *
 * @author ning.zhang
 * @date 2022/1/20
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditRefundEntity", description = "授信退款实体类")
@Entity
@TableName("dms_credit_refund")
@Table(name = "dms_credit_refund", indexes = {
    @Index(name = "dms_credit_refund_index1", columnList = "tenant_code"),
    @Index(name = "dms_credit_refund_index2", columnList = "cash_serial_number"),
    @Index(name = "dms_credit_refund_index3", columnList = "business_order_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_refund", comment = "授信退款实体类")
public class CreditRefundEntity extends TenantOpEntity {

  private static final long serialVersionUID = -4633146717805689765L;

  /**
   * 退款金额
   */
  @ApiModelProperty("退款金额")
  @Column(name = "refund_amount", columnDefinition = "decimal(20,4) NOT NULL COMMENT '退款金额'")
  private BigDecimal refundAmount;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  @Column(name = "order_type", columnDefinition = "VARCHAR(64) COMMENT '单据类型'")
  private String orderType;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  @Column(name = "cash_serial_number", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金流水号'")
  private String cashSerialNumber;

  /**
   * 业务单据号
   */
  @ApiModelProperty("业务单据号")
  @Column(name = "business_order_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '业务单据号'")
  private String businessOrderCode;
}
