package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 授信核销实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditWriteOffEntity", description = "授信核销实体类")
@Entity
@TableName("dms_credit_write_off")
@Table(name = "dms_credit_write_off", indexes = {
    @Index(name = "dms_credit_write_off_index1", columnList = "customer_code"),
    @Index(name = "dms_credit_write_off_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_write_off_index3", columnList = "cash_serial_number"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_write_off", comment = "授信核销表")
public class CreditWriteOffEntity extends TenantOpEntity {

  private static final long serialVersionUID = -7624345678610014741L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '客户编码'")
  private String customerCode;

  /**
   * 核销金额
   */
  @ApiModelProperty("核销金额")
  @Column(name = "write_off_amount", columnDefinition = "decimal(20,4) COMMENT '核销金额'")
  private BigDecimal writeOffAmount;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  @Column(name = "cash_serial_number", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金流水号'")
  private String cashSerialNumber;
}
