package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 授信核销明细实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditWriteOffItemEntity", description = "授信核销明细实体类")
@Entity
@TableName("dms_credit_write_off_item")
@Table(name = "dms_credit_write_off_item", indexes = {
    @Index(name = "dms_credit_write_off_index1", columnList = "write_off_id"),
    @Index(name = "dms_credit_write_off_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_write_off_index3", columnList = "order_code"),
    @Index(name = "dms_credit_write_off_index4", columnList = "credit_id"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_write_off_item", comment = "授信核销明细表")
public class CreditWriteOffItemEntity extends TenantOpEntity {

  private static final long serialVersionUID = 8794264098549750088L;

  /**
   * 核销ID
   */
  @ApiModelProperty(value = "核销ID")
  @Column(name = "write_off_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '核销ID'")
  private String writeOffId;

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  @Column(name = "credit_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '授信ID'")
  private String creditId;

  /**
   * 核销明细金额
   */
  @ApiModelProperty("核销明细金额")
  @Column(name = "write_off_item_amount", columnDefinition = "decimal(20,4) COMMENT '核销明细金额'")
  private BigDecimal writeOffItemAmount;

  /**
   * 单据编码
   */
  @ApiModelProperty("单据编码")
  @Column(name = "order_code", columnDefinition = "VARCHAR(64) COMMENT '单据编码'")
  private String orderCode;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  @Column(name = "order_type", columnDefinition = "VARCHAR(64) COMMENT '单据类型'")
  private String orderType;

  /**
   * 单据总金额
   */
  @ApiModelProperty("单据总金额")
  @Column(name = "order_amount", columnDefinition = "decimal(20,4) COMMENT '单据总金额'")
  private BigDecimal orderAmount;

}
