package com.biz.crm.dms.business.costpool.credit.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditVo;
import org.apache.ibatis.annotations.Param;

/**
 * 授信Vo的mybatis-plus接口类
 *
 * @author ning.zhang
 * @date 2021-12-14 20:08:46
 */
public interface CreditVoMapper {

  /**
   * 普通授信信息分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<CreditVo> 普通授信分页信息
   */
  Page<CreditVo> findByCreditPageDto(Page<CreditVo> page, @Param("dto") CreditPageDto dto);

  /**
   * 临时授信信息分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<CreditVo> 临时授信信息分页
   */
  Page<CreditVo> findByCreditTemporaryPageDto(Page<CreditVo> page, @Param("dto") CreditTemporaryPageDto dto);

  /**
   * 通过普通授信ID获取授信信息
   *
   * @param commonCreditId 普通授信ID
   * @return 授信信息
   */
  CreditVo findByCommonCreditId(@Param("commonCreditId") String commonCreditId);

  /**
   * 客户-商城授信头展示查询
   * @param dto
   * @return
   */
  CreditVo findByTotalCreditDto(@Param("dto") CreditDto dto);

  /**
   * 商城-临时授信申请记录信息分页列表
   * @param page
   * @param dto
   * @return
   */
  Page<CreditVo> findApplyRecordByCreditTemporaryPageDto(Page<CreditVo> page, @Param("dto") CreditTemporaryPageDto dto);
}

