package com.biz.crm.dms.business.costpool.credit.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffItemEntity;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffItemPageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 授信核销明细表的mybatis-plus接口类 {@link CreditWriteOffItemEntity}
 *
 * @author ning.zhang
 * @date 2021-12-21 15:27:46
 */
public interface CreditWriteOffItemMapper extends BaseMapper<CreditWriteOffItemEntity> {

  /**
   * 授信核销明细分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<CreditWriteOffItemEntity>  授信核销明细分页信息
   */
  Page<CreditWriteOffItemEntity> findByConditions(Page<CreditWriteOffItemEntity> page, @Param("dto") CreditWriteOffItemPageDto dto);
}

