package com.biz.crm.dms.business.costpool.credit.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRepayNoticeDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTempWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWaitWriteOffDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 授信待核销信息VO的mybatis-plus接口类
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
public interface CreditWriteOffVoMapper {

  /**
   * 普通授信核销信息分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<CreditWriteOffVo> 授信核销分页信息
   */
  Page<CreditWriteOffVo> findByConditions(Page<CreditWriteOffVo> page, @Param("dto") CreditWriteOffPageDto dto);

  /**
   * 临时授信核销明细分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<CreditWriteOffVo> 授信核销分页信息
   */
  Page<CreditWriteOffVo> findByCreditTempWriteOffPageDto(Page<CreditWriteOffVo> page, @Param("dto") CreditTempWriteOffPageDto dto);

  /**
   * 获取授信待核销明细信息
   *
   * @param dto 参数dto
   * @return 授信待核销信息
   */
  List<CreditWriteOffVo> findByCreditWaitWriteOffDto(@Param("dto") CreditWaitWriteOffDto dto);

  /**
   * 获取授信还款通知待核销信息
   *
   * @param dto 参数dto
   * @return 授信还款通知待核销信息
   */
  List<CreditWriteOffVo> findByCreditRepayNoticeDto(@Param("dto") CreditRepayNoticeDto dto);
}
