package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditDownUpAccountEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditDownUpAccountMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信回款上账表的数据库访问类 {@link CreditDownUpAccountEntity}
 *
 * @author ning.zhang
 * @date 2021-12-14 20:09:26
 */
@Component
public class CreditDownUpAccountRepository extends ServiceImpl<CreditDownUpAccountMapper, CreditDownUpAccountEntity> {

  /**
   * 查询授信回款上账信息
   *
   * @param dto 参数dto
   * @return 授信回款上账信息
   */
  public List<CreditDownUpAccountEntity> findByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return this.baseMapper.findByCreditCashFlowExtendDto(dto);
  }
}
