package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFreezeEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditFreezeMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 授信冻结表的数据库访问类 {@link CreditFreezeEntity}
 *
 * @author ning.zhang
 * @date 2021-12-14 20:10:01
 */
@Component
public class CreditFreezeRepository extends ServiceImpl<CreditFreezeMapper, CreditFreezeEntity> {

  /**
   * 查询冻结记录信息
   *
   * @param dto 参数dto
   * @return 冻结记录信息
   */
  public List<CreditFreezeEntity> findByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return this.lambdaQuery()
        .in(!CollectionUtils.isEmpty(dto.getCashSerialNumbers()), CreditFreezeEntity::getCashSerialNumber, dto.getCashSerialNumbers())
        .eq(CreditFreezeEntity::getTenantCode, dto.getTenantCode())
        .list();
  }
}
