package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditOccupyEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditOccupyMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.OccupyTypeEnum;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信占用实体类的数据库访问类 {@link CreditOccupyEntity}
 *
 * @author pengxi
 * @date 2022/6/24
 */
@Component
public class CreditOccupyRepository extends ServiceImpl<CreditOccupyMapper, CreditOccupyEntity> {

  /**
   * 通过业务单据号获取授信占用信息
   *
   * @param tenantCode        租户编码
   * @param businessOrderCode 业务单据号
   * @return 授信支付信息
   */
  public CreditOccupyEntity findOccupyByOccupyTypeAndBusinessOrderCode(String tenantCode, OccupyTypeEnum occupyTypeEnum, String businessOrderCode) {
    return this.lambdaQuery()
        .eq(CreditOccupyEntity::getTenantCode, tenantCode)
        .eq(CreditOccupyEntity::getBusinessOrderCode, businessOrderCode)
        .eq(CreditOccupyEntity::getOccupyType, occupyTypeEnum.getDictCode())
        .one();
  }

  /**
   * 查询授信占用信息
   *
   * @param dto 参数dto
   * @return 授信占用信息
   */
  public List<CreditOccupyEntity> findByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return this.lambdaQuery()
        .in(!CollectionUtils.isEmpty(dto.getCashSerialNumbers()), CreditOccupyEntity::getCashSerialNumber, dto.getCashSerialNumbers())
        .in(!CollectionUtils.isEmpty(dto.getOrderCodes()), CreditOccupyEntity::getBusinessOrderCode, dto.getOrderCodes())
        .eq(CreditOccupyEntity::getTenantCode, dto.getTenantCode())
        .list();
  }
}
