package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditReconcileStatsVoMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditReconcileStatsDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditReconcileStatsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 授信对账函数据统计VO的数据库访问类
 *
 * @author ning.zhang
 * @date 2022/4/8
 */
@Component
public class CreditReconcileStatsVoRepository {

  @Autowired(required = false)
  private CreditReconcileStatsVoMapper creditReconcileStatsVoMapper;

  /**
   * 获取授信对账函数据统计信息
   *
   * @param dto 参数dto
   * @return 授信对账函数据统计信息
   */
  public CreditReconcileStatsVo findByCreditReconcileStatsDto(CreditReconcileStatsDto dto) {
    return this.creditReconcileStatsVoMapper.findByCreditReconcileStatsDto(dto);
  }
}
