package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditRecordEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditRecordMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信记录表的数据库访问类 {@link CreditRecordEntity}
 *
 * @author ning.zhang
 * @date 2021-12-14 20:12:25
 */
@Component
public class CreditRecordRepository extends ServiceImpl<CreditRecordMapper, CreditRecordEntity> {

  /**
   * 查询授信记录信息
   *
   * @param dto 参数dto
   * @return 授信记录信息
   */
  public List<CreditRecordEntity> findByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return this.baseMapper.findByCreditCashFlowExtendDto(dto);
  }
}
