package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditWriteOffMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信核销表的数据库访问类 {@link CreditWriteOffEntity}
 *
 * @author ning.zhang
 * @date 2021-12-21 15:27:04
 */
@Component
public class CreditWriteOffRepository extends ServiceImpl<CreditWriteOffMapper, CreditWriteOffEntity> {

  /**
   * 批量获取客户核销记录信息(按时间倒序排列了)
   *
   * @param tenantCode 租户编码
   * @param customerCodes 客户编码集合
   * @return 核销记录信息
   */
  public List<CreditWriteOffEntity> findByCustomerCodes(String tenantCode, List<String> customerCodes) {
    return super.lambdaQuery()
        .eq(CreditWriteOffEntity::getTenantCode, tenantCode)
        .in(CreditWriteOffEntity::getCustomerCode, customerCodes)
        .orderByDesc(CreditWriteOffEntity::getCreateTime)
        .list();
  }
}
