package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditWriteOffStatsVoMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffInfoStatsDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffStatsVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 授信核销统计信息VO的数据库访问类
 *
 * @author ning.zhang
 * @date 2021/12/23
 */
@Component
public class CreditWriteOffStatsVoRepository {

  @Autowired(required = false)
  private CreditWriteOffStatsVoMapper creditWriteOffStatsVoMapper;

  /**
   * 获取授信核销明细的统计信息
   *
   * @param dto 参数dto
   * @return 授信核销明细的统计信息
   */
  public CreditWriteOffStatsVo findByCreditWriteOffInfoStatsDto(CreditWriteOffInfoStatsDto dto) {
    return this.creditWriteOffStatsVoMapper.findByCreditWriteOffInfoStatsDto(dto);
  }
}
