package com.biz.crm.dms.business.costpool.credit.local.service;

import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRepayNoticeDto;

import java.util.List;

/**
 * 授信表服务接口
 *
 * @author ning.zhang
 * @date 2021-12-14 20:08:46
 */
public interface CreditService {

  /**
   * 授信新增
   *
   * @param dto 参数dto
   */
  void create(CreditDto dto);

  /**
   * 授信修改
   *
   * @param dto 参数dto
   */
  void update(CreditDto dto);

  /**
   * 批量启用授信
   *
   * @param customerCodes 授信客户编码集合
   */
  void enableBatch(List<String> customerCodes);

  /**
   * 批量禁用授信
   *
   * @param customerCodes 授信客户编码集合
   */
  void disableBatch(List<String> customerCodes);

  /**
   * 批量删除授信
   *
   * @param ids 授信ID集合
   */
  void deleteBatch(List<String> ids);
  /**
   * 发送还款通知
   *
   * @param dto 参数dto
   */
  void sendNotice(CreditRepayNoticeDto dto);

  /**
   * 商城客户申请临时授信
   * @param dto
   */
  void handleTemporaryCreditApply(CreditDto dto);
}
