package com.biz.crm.dms.business.costpool.credit.local.service.helper;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 授信服务辅助类
 *
 * @author ning.zhang
 * @date 2022/5/20
 */
@Slf4j
@Service
public class CreditServiceHelper {

  /**
   * 计算授信资金已用金额
   *
   * @param cashEntity 授信资金信息
   * @return 资金已用金额
   */
  public BigDecimal calculateHaveUseAmount(CreditCashEntity cashEntity) {
    if (Objects.isNull(cashEntity)) {
      return BigDecimal.ZERO;
    }
    return cashEntity.getCreditAmount().subtract(cashEntity.getFreezeAmount()).subtract(cashEntity.getCanUseAmount());
  }
}
