package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowCustomerDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustGroupEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditCashFlowVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 授信资金流水VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2021/12/18
 */
@Service
public class CreditCashFlowVoServiceImpl implements CreditCashFlowVoService, CopyObjectCallback<CreditCashFlowEntity, CreditCashFlowVo> {

  @Autowired(required = false)
  private CreditCashFlowRepository creditCashFlowRepository;
  @Autowired(required = false)
  private List<CreditCashFlowRegister> registers;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public Page<CreditCashFlowVo> findByConditions(Pageable pageable, CreditCashFlowPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new CreditCashFlowPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    //关联订单查询资金流水
    if (StringUtils.isNotBlank(dto.getOrderCode())) {
      CreditCashFlowExtendDto extendDto = new CreditCashFlowExtendDto();
      extendDto.setOrderCodes(Lists.newArrayList(dto.getOrderCode()));
      Set<String> cashSerialNumbers = Sets.newHashSet();
      for (CreditCashFlowRegister register : this.registers) {
        List<CreditCashFlowExtendVo> extendList = register.onRequestByCreditCashFlowExtendDto(extendDto);
        if (!CollectionUtils.isEmpty(extendList)) {
          cashSerialNumbers.addAll(extendList.stream().map(CreditCashFlowExtendVo::getCashSerialNumber)
              .filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
        }
      }
      dto.setCashSerialNumbers(cashSerialNumbers);
    }
    Page<CreditCashFlowEntity> page = this.creditCashFlowRepository.findByConditions(pageable, dto);
    Page<CreditCashFlowVo> pageResult = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    if (CollectionUtils.isEmpty(page.getRecords())) {
      return pageResult;
    }
    List<CreditCashFlowVo> list = (List<CreditCashFlowVo>) this.nebulaToolkitService.copyCollectionByBlankList(page.getRecords()
        , CreditCashFlowEntity.class, CreditCashFlowVo.class, HashSet.class, ArrayList.class);
    pageResult.setRecords(list);
    return pageResult;
  }

  @Override
  public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
    return CreditCashFlowEntity.class.isAssignableFrom(sourceClass) && CreditCashFlowVo.class.isAssignableFrom(targetClass);
  }

  @Override
  public void callback(Class<CreditCashFlowEntity> sourceClass, List<CreditCashFlowEntity> sourceObjects,
                       Class<CreditCashFlowVo> targetClass, List<CreditCashFlowVo> targetObjects) {
    List<String> cashSerialNumbers = Lists.newArrayList();
    Map<String, CreditCashFlowVo> cashFlowMap = Maps.newHashMap();
    targetObjects.forEach(creditCashFlowVo -> {
      cashSerialNumbers.add(creditCashFlowVo.getCashSerialNumber());
      cashFlowMap.put(creditCashFlowVo.getCashSerialNumber(), creditCashFlowVo);
    });
    CreditCashFlowExtendDto extendDto = new CreditCashFlowExtendDto();
    extendDto.setCashSerialNumbers(cashSerialNumbers);
    for (CreditCashFlowRegister register : this.registers) {
      List<CreditCashFlowExtendVo> extendList = register.onRequestByCreditCashFlowExtendDto(extendDto);
      if (CollectionUtils.isEmpty(extendList)) {
        continue;
      }
      extendList.forEach(extendVo -> {
        CreditCashFlowVo flowVo = cashFlowMap.get(extendVo.getCashSerialNumber());
        flowVo.setExtendInfo(extendVo);
      });
    }
  }

  @Override
  public Page<CreditCashFlowVo> findByCreditCashFlowCustomerDto(Pageable pageable, CreditCashFlowCustomerDto dto) {
    LoginUserDetailsForEMS loginUserDetails = loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    if (StringUtils.isBlank(loginUserDetails.getCustomerCode()) || StringUtils.isBlank(dto.getGroup())) {
      return null;
    }
    CashAdjustGroupEnum groupEnum = CashAdjustGroupEnum.getByKey(dto.getGroup());
    if (Objects.isNull(groupEnum)) {
      return null;
    }
    List<String> adjustTypeList = CashAdjustOperateEnum.getDictCodeByGroupEnum(groupEnum);
    dto.setAdjustTypeList(adjustTypeList);
    dto.setCustomerCode(loginUserDetails.getCustomerCode());
    //查询
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<CreditCashFlowEntity> page = this.creditCashFlowRepository.findByCreditCashFlowCustomerDto(pageable, dto);
    Page<CreditCashFlowVo> pageResult = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    if (CollectionUtils.isEmpty(page.getRecords())) {
      return pageResult;
    }
    List<CreditCashFlowVo> list = (List<CreditCashFlowVo>) this.nebulaToolkitService.copyCollectionByBlankList(page.getRecords()
        , CreditCashFlowEntity.class, CreditCashFlowVo.class, HashSet.class, ArrayList.class);
    pageResult.setRecords(list);
    return pageResult;
  }
}
