package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.repository.CreditFileRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFileService;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFileEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditFileModelDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 授信相关文件表服务实现类
 *
 * @author ning.zhang
 * @date 2021-12-14 20:09:45
 */
@Slf4j
@Service("creditFileService")
public class CreditFileServiceImpl implements CreditFileService {

  @Autowired(required = false)
  private CreditFileRepository creditFileRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(List<CreditFileModelDto> dtoList) {
    Validate.isTrue(!CollectionUtils.isEmpty(dtoList), "文件信息不能为空");
    String tenantCode = TenantUtils.getTenantCode();
    List<String> businessIds = Lists.newArrayList();
    List<CreditFileEntity> entities = Lists.newArrayList();
    dtoList.forEach(dto -> {
      Validate.notNull(dto.getFileType(), "文件类型不能为空");
      Validate.notBlank(dto.getBusinessId(), "业务ID不能为空");
      businessIds.add(dto.getBusinessId());
      if (CollectionUtils.isEmpty(dto.getFileList())) {
        return;
      }
      List<CreditFileEntity> list = dto.getFileList().stream()
          //过滤无效的数据
          .filter(creditFileDto -> Objects.nonNull(creditFileDto) && StringUtils.isNotBlank(creditFileDto.getFileUrl()))
          .map(creditFileDto -> {
            creditFileDto.setId(null);
            CreditFileEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(creditFileDto, CreditFileEntity.class, HashSet.class, ArrayList.class);
            entity.setBusinessId(dto.getBusinessId());
            entity.setTenantCode(tenantCode);
            entity.setSortNum(dto.getFileList().indexOf(creditFileDto));
            entity.setFileType(dto.getFileType());
            return entity;
          }).collect(Collectors.toList());
      if (!CollectionUtils.isEmpty(list)) {
        entities.addAll(list);
      }
    });
    this.creditFileRepository.deleteByBusinessIds(businessIds);
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.creditFileRepository.saveBatch(entities);
  }
}
