package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffVoRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTempWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditWriteOffVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 授信核销信息vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Component
public class CreditWriteOffVoServiceImpl implements CreditWriteOffVoService {

  @Autowired(required = false)
  private CreditWriteOffVoRepository creditWriteOffVoRepository;
  @Autowired(required = false)
  private CreditWriteOffRepository creditWriteOffRepository;

  @Override
  public Page<CreditWriteOffVo> findByConditions(Pageable pageable, CreditWriteOffPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new CreditWriteOffPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<CreditWriteOffVo> page = this.creditWriteOffVoRepository.findByConditions(pageable, dto);
    this.perfectCreditWriteOffInfo(page.getRecords());
    return page;
  }

  @Override
  public Page<CreditWriteOffVo> findByCreditTempWriteOffPageDto(Pageable pageable, CreditTempWriteOffPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new CreditTempWriteOffPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    if (StringUtils.isBlank(dto.getCustomerCode())) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    Page<CreditWriteOffVo> page = this.creditWriteOffVoRepository.findByCreditTempWriteOffPageDto(pageable, dto);
    this.perfectCreditWriteOffInfo(page.getRecords());
    return page;
  }

  /**
   * 完善授信核销信息
   *
   * @param list 授信核销信息列表
   */
  private void perfectCreditWriteOffInfo(List<CreditWriteOffVo> list) {
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    List<String> customerCodes = list.stream().map(CreditWriteOffVo::getCustomerCode).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(customerCodes)) {
      return;
    }
    List<CreditWriteOffEntity> writeOffEntities = this.creditWriteOffRepository.findByCustomerCodes(TenantUtils.getTenantCode(), customerCodes);
    if (CollectionUtils.isEmpty(writeOffEntities)) {
      return;
    }
    //映射客户编码-核销信息,多个取第一个也就是最近一个(前面的列表已经按时间倒序排列,所以第一个也就是最近一个)
    Map<String, CreditWriteOffEntity> writeOffEntityMap = writeOffEntities.stream()
        .collect(Collectors.toMap(CreditWriteOffEntity::getCustomerCode, t -> t, (a, b) -> a));
    list.forEach(creditWriteOffVo -> {
      CreditWriteOffEntity writeOffEntity = writeOffEntityMap.getOrDefault(creditWriteOffVo.getCustomerCode(), new CreditWriteOffEntity());
      creditWriteOffVo.setRecentlyWriteOffTime(writeOffEntity.getCreateTime());
    });
  }
}
