package com.biz.crm.dms.business.costpool.credit.local.service.observer;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFileEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditFileRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.constant.CreditConstant;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditFileType;
import com.biz.crm.dms.business.costpool.credit.sdk.event.CreditEventListener;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditEventVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditFileVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.biz.crm.workflow.sdk.dto.CallBackDto;
import com.biz.crm.workflow.sdk.listener.CallBackListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 临时授信审批回调类
 */
@Component
public class CreditProcessCallBackListener implements CallBackListener {

  @Autowired(required = false)
  private CreditRepository creditRepository;
  @Autowired(required = false)
  private List<CreditEventListener> listeners;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CreditFileRepository creditFileRepository;

  @Override
  @Transactional
  public void onCallBack(CallBackDto dto) {
    if (!dto.getFormType().equals(CreditConstant.CREDIT_PROCESS_NAME)) {
      return;
    }
    //校验单号
    CreditEntity creditEntity = this.creditRepository.findByCreditProcessNo(dto.getProcessNo());
    if (ObjectUtils.isEmpty(creditEntity)) {
      return;
    }
    //校验授信审批状态
    Validate.isTrue(creditEntity.getProcessStatus().equals(ActApproveStatusEnum.APPROVING.getCode()), "此订单非审批中状态，无法进行操作！");
    //更改授信审批状态
    creditEntity.setProcessStatus(String.valueOf(dto.getProcessState()));
    creditEntity.setProcessRemark(dto.getRemark());
    this.creditRepository.updateById(creditEntity);
    List<CreditFileEntity> fileEntities = this.creditFileRepository.findByBusinessIdAndFileType(creditEntity.getId(), CreditFileType.CREDIT.getDictCode());
    CreditEventVo eventVo = this.nebulaToolkitService.copyObjectByWhiteList(creditEntity, CreditEventVo.class, HashSet.class, ArrayList.class);
    if (!CollectionUtils.isEmpty(fileEntities)) {
      eventVo.setFileList((List<CreditFileVo>) this.nebulaToolkitService
          .copyCollectionByWhiteList(fileEntities,CreditFileEntity.class,CreditFileVo.class,HashSet.class,ArrayList.class));
    }
    //审批授信事件通知
    if (!CollectionUtils.isEmpty(listeners)) {
      listeners.forEach(listener -> {
        listener.onApprove(Lists.newArrayList(eventVo));
      });
    }
  }
}
