package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCreateCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 授信开通-资金流水注册器实现
 * <p>
 * <p>
 * 适用场景描述:
 * 主要用于普通授信开通和临时授信开通,授信开通的业务场景,创建授信资金表记录,保存流水拆分明细
 *
 * @author ning.zhang
 * @date 2021/12/16
 */
@Component
public class CreditCreateCashFlowRegisterImpl implements CreditCashFlowRegister<CreditCreateCashDto> {

  @Autowired(required = false)
  private CreditCashFlowItemRepository creditCashFlowItemRepository;
  @Autowired(required = false)
  private CreditCashRepository creditCashRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class<CreditCreateCashDto> getClazz() {
    return CreditCreateCashDto.class;
  }

  @Override
  @Transactional
  public List<CreditCashVo> onCreate(CreditCreateCashDto dto) {
    Validate.notBlank(dto.getCreditId(), "缺失授信ID");
    //持久化授信资金池
    CreditCashEntity cashEntity = new CreditCashEntity();
    cashEntity.setCreditId(dto.getCreditId());
    cashEntity.setCreditType(dto.getCreditType());
    cashEntity.setCustomerCode(dto.getCustomerCode());
    cashEntity.setCanUseAmount(dto.getOperateAmount());
    cashEntity.setCreditAmount(dto.getOperateAmount());
    cashEntity.setFreezeAmount(BigDecimal.ZERO);
    cashEntity.setWriteOffAmount(BigDecimal.ZERO);
    cashEntity.setTenantCode(dto.getTenantCode());
    this.creditCashRepository.save(cashEntity);
    //持久化资金流水拆分信息
    CreditCashFlowItemEntity cashFlowItemEntity = new CreditCashFlowItemEntity();
    cashFlowItemEntity.setTenantCode(dto.getTenantCode());
    cashFlowItemEntity.setCreditId(dto.getCreditId());
    cashFlowItemEntity.setItemAmount(dto.getOperateAmount());
    cashFlowItemEntity.setCashFlowId(dto.getId());
    this.creditCashFlowItemRepository.save(cashFlowItemEntity);
    return Lists.newArrayList(this.nebulaToolkitService.copyObjectByWhiteList(cashEntity, CreditCashVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return Lists.newLinkedList();
  }
}
