package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffItemCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 授信核销-资金流水注册器实现
 * <p>
 * <p>
 * 适用场景描述:
 * 主要用于授信核销,创建授信资金表记录,保存流水拆分明细
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Component
public class CreditWriteOffCashFlowRegisterImpl implements CreditCashFlowRegister<CreditWriteOffCashDto> {

  @Autowired(required = false)
  private CreditCashFlowItemRepository creditCashFlowItemRepository;
  @Autowired(required = false)
  private CreditCashRepository creditCashRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Class<CreditWriteOffCashDto> getClazz() {
    return CreditWriteOffCashDto.class;
  }

  @Override
  @Transactional
  public List<CreditCashVo> onCreate(CreditWriteOffCashDto dto) {
    Validate.isTrue(!CollectionUtils.isEmpty(dto.getWriteOffItemList()), "缺失授信核销明细信息");
    List<String> creditIds = dto.getWriteOffItemList().stream().map(CreditWriteOffItemCashDto::getCreditId).collect(Collectors.toList());
    List<CreditCashEntity> cashEntities = creditCashRepository.findByCreditIds(creditIds);
    Validate.isTrue(!CollectionUtils.isEmpty(cashEntities), "授信资金异常!");
    Map<String, CreditCashEntity> cashEntityMap = cashEntities.stream().collect(Collectors.toMap(CreditCashEntity::getCreditId, t -> t));
    List<CreditCashEntity> updateCashEntities = Lists.newArrayList();
    List<CreditCashFlowItemEntity> saveFlowItemEntities = Lists.newArrayList();
    dto.getWriteOffItemList().forEach(cashDto -> {
      //授信资金信息
      CreditCashEntity cashEntity = cashEntityMap.get(cashDto.getCreditId());
      Validate.notNull(cashEntity, "授信资金异常!");
      BigDecimal waitWriteOffAmount = cashEntity.getCreditAmount().subtract(cashEntity.getFreezeAmount()).subtract(cashEntity.getCanUseAmount());
      BigDecimal remainWriteOffAmount = waitWriteOffAmount.subtract(cashDto.getWriteOffAmount());
      //冻结
      Validate.isTrue(remainWriteOffAmount.compareTo(BigDecimal.ZERO) >= 0
          , String.format("核销额度超过待核销额度,无法执行[%s]操作", dto.getAdjustOperateName()));
      cashEntity.setWriteOffAmount(cashEntity.getWriteOffAmount().add(cashDto.getWriteOffAmount()));
      cashEntity.setCanUseAmount(cashEntity.getCanUseAmount().add(cashDto.getWriteOffAmount()));
      updateCashEntities.add(cashEntity);
      //资金流水拆分信息
      CreditCashFlowItemEntity cashFlowItemEntity = new CreditCashFlowItemEntity();
      cashFlowItemEntity.setTenantCode(dto.getTenantCode());
      cashFlowItemEntity.setCreditId(cashDto.getCreditId());
      cashFlowItemEntity.setItemAmount(cashDto.getWriteOffAmount());
      cashFlowItemEntity.setCashFlowId(dto.getId());
      saveFlowItemEntities.add(cashFlowItemEntity);
    });
    //更新资金可用额度和冻结额度
    this.creditCashRepository.updateBatchById(updateCashEntities);
    //持久化资金流水拆分信息
    this.creditCashFlowItemRepository.saveBatch(saveFlowItemEntities);
    return (List<CreditCashVo>) this.nebulaToolkitService.copyCollectionByWhiteList(cashEntities, CreditCashEntity.class
        , CreditCashVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return Lists.newLinkedList();
  }
}
