/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFreezeService;
import com.biz.crm.dms.business.costpool.credit.sdk.constant.CreditConstant;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditFreezeDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/credit/freeze"})
@Api(tags={"\u6388\u4fe1\u7ba1\u7406: CreditFreeze: \u6388\u4fe1\u51bb\u7ed3\u89e3\u51bb"})
public class CreditFreezeController {
    private static final Logger log = LoggerFactory.getLogger(CreditFreezeController.class);
    @Autowired(required=false)
    private CreditFreezeService creditFreezeService;
    @Autowired(required=false)
    private CreditVoService creditVoService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u6388\u4fe1\u51bb\u7ed3")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody CreditFreezeDto dto) {
        String lockKey = this.creditVoService.buildCashLockKeyByCreditId(dto.getCreditId());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CreditConstant.CREDIT_TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.creditFreezeService.create(dto);
            Result result = Result.ok();
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }
}

