/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowCustomerDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustGroupEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditCashFlowVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreditCashFlowVoServiceImpl
implements CreditCashFlowVoService,
CopyObjectCallback<CreditCashFlowEntity, CreditCashFlowVo> {
    @Autowired(required=false)
    private CreditCashFlowRepository creditCashFlowRepository;
    @Autowired(required=false)
    private List<CreditCashFlowRegister> registers;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<CreditCashFlowVo> findByConditions(Pageable pageable, CreditCashFlowPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CreditCashFlowPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CreditCashFlowPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotBlank((CharSequence)dto.getOrderCode())) {
            CreditCashFlowExtendDto extendDto = new CreditCashFlowExtendDto();
            extendDto.setOrderCodes((List)Lists.newArrayList((Object[])new String[]{dto.getOrderCode()}));
            HashSet cashSerialNumbers = Sets.newHashSet();
            for (CreditCashFlowRegister register : this.registers) {
                List extendList = register.onRequestByCreditCashFlowExtendDto(extendDto);
                if (CollectionUtils.isEmpty((Collection)extendList)) continue;
                cashSerialNumbers.addAll(extendList.stream().map(CreditCashFlowExtendVo::getCashSerialNumber).filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
            }
            dto.setCashSerialNumbers((Set)cashSerialNumbers);
        }
        Page<CreditCashFlowEntity> page = this.creditCashFlowRepository.findByConditions(pageable, dto);
        Page pageResult = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)page.getRecords(), CreditCashFlowEntity.class, CreditCashFlowVo.class, HashSet.class, ArrayList.class, new String[0]);
        pageResult.setRecords(list);
        return pageResult;
    }

    public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
        return CreditCashFlowEntity.class.isAssignableFrom(sourceClass) && CreditCashFlowVo.class.isAssignableFrom(targetClass);
    }

    public void callback(Class<CreditCashFlowEntity> sourceClass, List<CreditCashFlowEntity> sourceObjects, Class<CreditCashFlowVo> targetClass, List<CreditCashFlowVo> targetObjects) {
        ArrayList cashSerialNumbers = Lists.newArrayList();
        HashMap cashFlowMap = Maps.newHashMap();
        targetObjects.forEach(creditCashFlowVo -> {
            cashSerialNumbers.add(creditCashFlowVo.getCashSerialNumber());
            cashFlowMap.put(creditCashFlowVo.getCashSerialNumber(), creditCashFlowVo);
        });
        CreditCashFlowExtendDto extendDto = new CreditCashFlowExtendDto();
        extendDto.setCashSerialNumbers((List)cashSerialNumbers);
        for (CreditCashFlowRegister register : this.registers) {
            List extendList = register.onRequestByCreditCashFlowExtendDto(extendDto);
            if (CollectionUtils.isEmpty((Collection)extendList)) continue;
            extendList.forEach(extendVo -> {
                CreditCashFlowVo flowVo = (CreditCashFlowVo)cashFlowMap.get(extendVo.getCashSerialNumber());
                flowVo.setExtendInfo(extendVo);
            });
        }
    }

    public Page<CreditCashFlowVo> findByCreditCashFlowCustomerDto(Pageable pageable, CreditCashFlowCustomerDto dto) {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        if (StringUtils.isBlank((CharSequence)loginUserDetails.getCustomerCode()) || StringUtils.isBlank((CharSequence)dto.getGroup())) {
            return null;
        }
        CashAdjustGroupEnum groupEnum = CashAdjustGroupEnum.getByKey((String)dto.getGroup());
        if (Objects.isNull(groupEnum)) {
            return null;
        }
        List adjustTypeList = CashAdjustOperateEnum.getDictCodeByGroupEnum((CashAdjustGroupEnum)groupEnum);
        dto.setAdjustTypeList(adjustTypeList);
        dto.setCustomerCode(loginUserDetails.getCustomerCode());
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CreditCashFlowEntity> page = this.creditCashFlowRepository.findByCreditCashFlowCustomerDto(pageable, dto);
        Page pageResult = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return pageResult;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)page.getRecords(), CreditCashFlowEntity.class, CreditCashFlowVo.class, HashSet.class, ArrayList.class, new String[0]);
        pageResult.setRecords(list);
        return pageResult;
    }
}

