/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashVoService;
import com.biz.crm.dms.business.costpool.credit.local.service.helper.CreditServiceHelper;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreditCashVoServiceImpl
implements CreditCashVoService {
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private CreditRepository creditRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditServiceHelper creditServiceHelper;

    @Override
    public Map<String, CreditCashVo> findByCreditCashModelDto(CreditCashModelDto dto) {
        Map<Object, Object> resultMap = Maps.newHashMap();
        if (Objects.isNull(dto)) {
            return resultMap;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CreditCashEntity> entities = this.creditCashRepository.findByCreditCashModelDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return resultMap;
        }
        List creditEntities = this.creditRepository.listByIds(entities.stream().map(CreditCashEntity::getCreditId).collect(Collectors.toList()));
        Map<String, CreditEntity> creditEntityMap = creditEntities.stream().collect(Collectors.toMap(UuidEntity::getId, t -> t, (key1, key2) -> key2));
        resultMap = entities.stream().collect(Collectors.toMap(CreditCashEntity::getCreditId, cashEntity -> {
            CreditCashVo cashModelVo = (CreditCashVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)cashEntity, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0]);
            CreditEntity creditEntity = (CreditEntity)((Object)((Object)creditEntityMap.get(cashEntity.getCreditId())));
            cashModelVo.setCreditStartTime(creditEntity.getCreditStartTime());
            cashModelVo.setCreditType(creditEntity.getCreditType());
            cashModelVo.setCreditEndTime(creditEntity.getCreditEndTime());
            cashModelVo.setHaveUseAmount(this.creditServiceHelper.calculateHaveUseAmount((CreditCashEntity)((Object)cashEntity)));
            return cashModelVo;
        }));
        return resultMap;
    }
}

