/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCustomerVoRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCustomerVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryCustomerPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCustomerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreditCustomerVoServiceImpl
implements CreditCustomerVoService {
    @Autowired(required=false)
    private CreditCustomerVoRepository creditCustomerVoRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<CreditCustomerVo> findByCreditTemporaryCustomerPageDto(Pageable pageable, CreditTemporaryCustomerPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CreditTemporaryCustomerPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CreditTemporaryCustomerPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setNowDate(new Date());
        Page<CreditCustomerVo> page = this.creditCustomerVoRepository.findByCreditTemporaryCustomerPageDto(pageable, dto);
        Page resultPage = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        resultPage.setTotal(page.getTotal());
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return resultPage;
        }
        List customerCodes = page.getRecords().stream().map(CreditCustomerVo::getCustomerCode).collect(Collectors.toList());
        List list = this.customerVoService.findByCustomerCodes(customerCodes);
        if (CollectionUtils.isEmpty(customerCodes)) {
            return resultPage;
        }
        List voList = list.stream().map(customerVo -> {
            CreditCustomerVo vo = (CreditCustomerVo)this.nebulaToolkitService.copyObjectByWhiteList(customerVo, CreditCustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
            if (CollectionUtils.isEmpty((Collection)customerVo.getOrgList())) {
                return vo;
            }
            ArrayList orgNameList = Lists.newArrayList();
            ArrayList orgNCodeList = Lists.newArrayList();
            customerVo.getOrgList().forEach(customerRelateOrgVo -> {
                orgNameList.add(customerRelateOrgVo.getOrgName());
                orgNCodeList.add(customerRelateOrgVo.getOrgCode());
            });
            vo.setOrgCode(String.join((CharSequence)",", orgNCodeList));
            vo.setOrgName(String.join((CharSequence)",", orgNameList));
            return vo;
        }).collect(Collectors.toList());
        resultPage.setRecords(voList);
        return resultPage;
    }
}

