/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFileEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditFileModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditFileRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFileService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="creditFileService")
public class CreditFileServiceImpl
implements CreditFileService {
    private static final Logger log = LoggerFactory.getLogger(CreditFileServiceImpl.class);
    @Autowired(required=false)
    private CreditFileRepository creditFileRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<CreditFileModelDto> dtoList) {
        Validate.isTrue((!CollectionUtils.isEmpty(dtoList) ? 1 : 0) != 0, (String)"\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList businessIds = Lists.newArrayList();
        ArrayList entities = Lists.newArrayList();
        dtoList.forEach(dto -> {
            Validate.notNull((Object)dto.getFileType(), (String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)dto.getBusinessId(), (String)"\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            businessIds.add(dto.getBusinessId());
            if (CollectionUtils.isEmpty(dto.getFileList())) {
                return;
            }
            List list = dto.getFileList().stream().filter(creditFileDto -> Objects.nonNull(creditFileDto) && StringUtils.isNotBlank((CharSequence)creditFileDto.getFileUrl())).map(creditFileDto -> {
                creditFileDto.setId(null);
                CreditFileEntity entity = (CreditFileEntity)((Object)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(creditFileDto, CreditFileEntity.class, HashSet.class, ArrayList.class, new String[0]))));
                entity.setBusinessId(dto.getBusinessId());
                entity.setTenantCode(tenantCode);
                entity.setSortNum(dto.getFileList().indexOf(creditFileDto));
                entity.setFileType(dto.getFileType());
                return entity;
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                entities.addAll(list);
            }
        });
        this.creditFileRepository.deleteByBusinessIds(businessIds);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        this.creditFileRepository.saveBatch(entities);
    }
}

