/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditRefundEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRefundRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashFlowService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditRefundService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRefundCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRefundDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditOrderTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="creditRefundService")
public class CreditRefundServiceImpl
implements CreditRefundService {
    private static final Logger log = LoggerFactory.getLogger(CreditRefundServiceImpl.class);
    @Autowired(required=false)
    private CreditRefundRepository creditRefundRepository;
    @Autowired(required=false)
    private CreditCashFlowService creditCashFlowService;

    @Override
    @Transactional
    public void create(CreditRefundDto dto) {
        this.createValidation(dto);
        CashAdjustOperateEnum adjustOperate = CashAdjustOperateEnum.getByDictCode((String)dto.getAdjustOperateCode());
        CashAdjustTypeEnum adjustType = CashAdjustTypeEnum.getByDictCode((String)dto.getAdjustTypeCode());
        CreditRefundEntity entity = new CreditRefundEntity();
        entity.setBusinessOrderCode(dto.getFromCode());
        entity.setRefundAmount(dto.getAmount());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setOrderType(CreditOrderTypeEnum.REFUND_ORDER.getDictCode());
        CreditRefundCashDto cashFlowDto = new CreditRefundCashDto();
        cashFlowDto.setBusinessOrderCode(dto.getFromCode());
        cashFlowDto.setOperateAmount(dto.getAmount());
        cashFlowDto.setCustomerCode(dto.getCustomerCode());
        cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
        cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
        cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
        cashFlowDto.setAdjustTypeName(adjustType.getValue());
        CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
        entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
        this.creditRefundRepository.save((Object)entity);
    }

    private void createValidation(CreditRefundDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAdjustOperateCode(), (String)"\u7f3a\u5931\u8c03\u6574\u64cd\u4f5c\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAdjustTypeCode(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFromCode(), (String)"\u7f3a\u5931\u6765\u6e90\u7f16\u7801!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAmount(), (String)"\u7f3a\u5931\u91d1\u989d!", (Object[])new Object[0]);
        Validate.isTrue((dto.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((boolean)CashAdjustTypeEnum.CREDIT_RELEASE.getDictCode().equals(dto.getAdjustTypeCode()), (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u8c03\u6574\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.isTrue((CashAdjustOperateEnum.CLOSE_ORDER.getDictCode().equals(dto.getAdjustOperateCode()) || CashAdjustOperateEnum.RETURN_ORDER.getDictCode().equals(dto.getAdjustOperateCode()) ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u8c03\u6574\u64cd\u4f5c\uff01", (Object[])new Object[0]);
    }
}

