/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFileEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditFileRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditVoRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditFileType;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditFileVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerContactVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CreditVoServiceImpl
implements CreditVoService {
    @Autowired(required=false)
    private CreditVoRepository creditVoRepository;
    @Autowired(required=false)
    private CreditRepository creditRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditFileRepository creditFileRepository;

    public Page<CreditVo> findByCreditCommonPageDto(Pageable pageable, CreditPageDto dto) {
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CreditPageDto)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)dto, (Object)new CreditPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.creditVoRepository.findByCreditPageDto(pageable, dto);
    }

    public Page<CreditVo> findByCreditTemporaryPageDto(Pageable pageable, CreditTemporaryPageDto dto) {
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CreditTemporaryPageDto)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)dto, (Object)new CreditTemporaryPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.creditVoRepository.findByCreditTemporaryPageDto(pageable, dto);
    }

    public CreditVo findByCommonCreditId(String commonCreditId) {
        if (StringUtils.isBlank((CharSequence)commonCreditId)) {
            return null;
        }
        return this.creditVoRepository.findByCommonCreditId(commonCreditId);
    }

    public String buildCashLockKeyByCreditId(String creditId) {
        Validate.notBlank((CharSequence)creditId, (String)"\u6388\u4fe1id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CreditEntity creditEntity = (CreditEntity)((Object)this.creditRepository.getById((Serializable)((Object)creditId)));
        Validate.notNull((Object)((Object)creditEntity), (String)"\u6388\u4fe1\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        return String.format("creditCashChangeLock_%s", creditEntity.getCustomerCode());
    }

    public String buildCashLockKeyByCustomerCode(String customerCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return String.format("creditCashChangeLock_%s", customerCode);
    }

    public CreditVo findByTotalCreditDto(CreditDto dto) {
        CreditVo creditVo = new CreditVo();
        creditVo.setLongAmount(BigDecimal.ZERO);
        creditVo.setLongCanUseAmount(BigDecimal.ZERO);
        creditVo.setLongFreezeAmount(BigDecimal.ZERO);
        creditVo.setLongHaveUseAmount(BigDecimal.ZERO);
        creditVo.setTemporaryAmount(BigDecimal.ZERO);
        creditVo.setTemporaryCanUseAmount(BigDecimal.ZERO);
        creditVo.setTemporaryFreezeAmount(BigDecimal.ZERO);
        creditVo.setTemporaryHaveUseAmount(BigDecimal.ZERO);
        creditVo.setTotalAmount(BigDecimal.ZERO);
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        if (StringUtils.isBlank((CharSequence)loginUserDetails.getCustomerCode())) {
            return creditVo;
        }
        dto.setCustomerCode(loginUserDetails.getCustomerCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        creditVo = this.creditVoRepository.findByTotalCreditDto(dto);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)creditVo)) {
            return null;
        }
        CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, loginUserDetails.getCustomerCode());
        if (Objects.nonNull(customerVo)) {
            creditVo.setRegisteredAddress(customerVo.getRegisteredAddress());
            List contactList = customerVo.getContactList();
            if (!CollectionUtils.isEmpty((Collection)contactList)) {
                CustomerContactVo customerContactVo = contactList.stream().filter(CustomerContactVo::getContactMain).findFirst().orElse(new CustomerContactVo());
                creditVo.setContactName(customerContactVo.getContactName());
                creditVo.setContactPhone(customerContactVo.getContactPhone());
            }
        }
        return creditVo;
    }

    public Page<CreditVo> findApplyRecordByCreditTemporaryPageDto(Pageable pageable, CreditTemporaryPageDto dto) {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        if (StringUtils.isBlank((CharSequence)loginUserDetails.getCustomerCode())) {
            Page pageResult = new Page(0L, 0L, 0L);
            return pageResult;
        }
        dto.setCreditType(CreditType.TEMPORARY_CREDIT.getDictCode());
        dto.setCustomerCode(loginUserDetails.getCustomerCode());
        pageable = (Pageable)org.apache.commons.lang3.ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CreditVo> entityResult = this.creditVoRepository.findApplyRecordByCreditTemporaryPageDto((Page<CreditVo>)page, dto);
        return entityResult;
    }

    public Page<CreditVo> findRecordByCreditTemporaryPageDto(Pageable pageable, CreditTemporaryPageDto dto) {
        LoginUserDetailsForEMS loginUserDetails = (LoginUserDetailsForEMS)this.loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
        if (StringUtils.isBlank((CharSequence)loginUserDetails.getCustomerCode())) {
            Page pageResult = new Page(0L, 0L, 0L);
            return pageResult;
        }
        dto.setCreditType(CreditType.TEMPORARY_CREDIT.getDictCode());
        dto.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setCustomerCode(loginUserDetails.getCustomerCode());
        return this.creditVoRepository.findByCreditTemporaryPageDto(pageable, dto);
    }

    public CreditVo findByCreditTemporaryId(String creditTemporaryId) {
        CustomerVo customerVo;
        Validate.notBlank((CharSequence)creditTemporaryId, (String)"\u4e34\u65f6\u6388\u4fe1ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CreditEntity creditEntity = (CreditEntity)((Object)this.creditRepository.getById((Serializable)((Object)creditTemporaryId)));
        Validate.isTrue((!ObjectUtils.isEmpty((Object)((Object)creditEntity)) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u4e34\u65f6\u6388\u4fe1\u4fe1\u606f", (Object[])new Object[0]);
        CreditVo creditVo = (CreditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)creditEntity, CreditVo.class, HashSet.class, ArrayList.class, new String[0]);
        creditVo.setTemporaryAmount(creditEntity.getCreditAmount());
        List<CreditFileEntity> creditFileEntities = this.creditFileRepository.findByBusinessIdAndFileType(creditVo.getId(), CreditFileType.CREDIT.getDictCode());
        if (!CollectionUtils.isEmpty(creditFileEntities)) {
            List creditFileVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(creditFileEntities, CreditFileEntity.class, CreditFileVo.class, HashSet.class, ArrayList.class, new String[0]);
            creditVo.setFileList(creditFileVos);
        }
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)(customerVo = this.customerVoService.findDetailsByIdOrCode(null, creditVo.getCustomerCode())))) {
            creditVo.setRegisteredAddress(customerVo.getRegisteredAddress());
            creditVo.setCustomerName(customerVo.getCustomerName());
            List contactList = customerVo.getContactList();
            if (!CollectionUtils.isEmpty((Collection)contactList)) {
                CustomerContactVo customerContactVo = contactList.stream().filter(CustomerContactVo::getContactMain).findFirst().orElse(new CustomerContactVo());
                creditVo.setContactName(customerContactVo.getContactName());
                creditVo.setContactPhone(customerContactVo.getContactPhone());
            }
        }
        return creditVo;
    }
}

