/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashFlowService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditWriteOffService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffItemCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffOrderDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="creditWriteOffService")
public class CreditWriteOffServiceImpl
implements CreditWriteOffService {
    private static final Logger log = LoggerFactory.getLogger(CreditWriteOffServiceImpl.class);
    @Autowired(required=false)
    private CreditWriteOffRepository creditWriteOffRepository;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private CreditRepository creditRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditWriteOffItemRepository creditWriteOffItemRepository;
    @Autowired(required=false)
    private CreditCashFlowService creditCashFlowService;

    @Override
    @Transactional
    public void create(CreditWriteOffDto dto) {
        this.createValidation(dto);
        ArrayList creditIds = Lists.newArrayList();
        dto.getWriteOffInfoList().forEach(infoDto -> creditIds.addAll(infoDto.getCreditIds()));
        List<CreditCashEntity> cashEntities = this.creditCashRepository.findByCreditIds(creditIds);
        Validate.isTrue((!CollectionUtils.isEmpty(cashEntities) ? 1 : 0) != 0, (String)"\u6388\u4fe1\u8d44\u91d1\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        List creditEntities = this.creditRepository.listByIds(creditIds);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)creditEntities) ? 1 : 0) != 0, (String)"\u6388\u4fe1\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Map<String, CreditCashEntity> cashEntityMap = cashEntities.stream().collect(Collectors.toMap(CreditCashEntity::getCreditId, t -> t));
        Map<String, CreditEntity> creditEntityMap = creditEntities.stream().collect(Collectors.toMap(UuidEntity::getId, t -> t));
        ArrayList writeOffItemEntities = Lists.newArrayList();
        dto.getWriteOffInfoList().forEach(infoDto -> {
            List<CreditEntity> list = infoDto.getCreditIds().stream().map(creditId -> {
                CreditEntity creditEntity = (CreditEntity)((Object)((Object)((Object)creditEntityMap.get(creditId))));
                Validate.notNull((Object)((Object)creditEntity), (String)"\u6388\u4fe1\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
                Validate.isTrue((boolean)creditEntity.getCustomerCode().equals(dto.getCustomerCode()), (String)"\u6388\u4fe1\u4fe1\u606f\u4e0e\u5ba2\u6237\u4fe1\u606f\u4e0d\u5339\u914d!", (Object[])new Object[0]);
                Validate.isTrue((boolean)creditEntity.getCreditEndTime().before(new Date()), (String)String.format("\u6388\u4fe1\u4fe1\u606f[%s],\u6b63\u5728\u4f7f\u7528\u4e2d,\u65e0\u6cd5\u6838\u9500!", creditEntity.getCreditCode()), (Object[])new Object[0]);
                return creditEntity;
            }).sorted((o1, o2) -> o2.getRepayEndTime().compareTo(o1.getRepayEndTime())).collect(Collectors.toList());
            writeOffItemEntities.addAll(this.buildCreditWriteOffItem(cashEntityMap, infoDto.getOrderList(), list));
        });
        this.save(dto, writeOffItemEntities);
    }

    private void save(CreditWriteOffDto dto, List<CreditWriteOffItemEntity> writeOffItemEntities) {
        CreditWriteOffEntity writeOffEntity = new CreditWriteOffEntity();
        writeOffEntity.setCustomerCode(dto.getCustomerCode());
        writeOffEntity.setTenantCode(dto.getTenantCode());
        writeOffEntity.setWriteOffAmount(BigDecimal.ZERO);
        HashMap itemCashMap = Maps.newHashMap();
        writeOffItemEntities.forEach(itemEntity -> {
            writeOffEntity.setWriteOffAmount(writeOffEntity.getWriteOffAmount().add(itemEntity.getWriteOffItemAmount()));
            CreditWriteOffItemCashDto itemCashDto = (CreditWriteOffItemCashDto)itemCashMap.get(itemEntity.getCreditId());
            if (Objects.nonNull(itemCashDto)) {
                itemCashDto.setWriteOffAmount(itemCashDto.getWriteOffAmount().add(itemEntity.getWriteOffItemAmount()));
            } else {
                itemCashDto = new CreditWriteOffItemCashDto();
                itemCashDto.setWriteOffAmount(itemEntity.getWriteOffItemAmount());
                itemCashDto.setCreditId(itemEntity.getCreditId());
                itemCashMap.put(itemEntity.getCreditId(), itemCashDto);
            }
        });
        CashAdjustOperateEnum adjustOperate = CashAdjustOperateEnum.CREDIT_WRITE_OFF;
        CashAdjustTypeEnum adjustType = CashAdjustTypeEnum.CREDIT_WRITE_OFF;
        CreditWriteOffCashDto cashFlowDto = new CreditWriteOffCashDto();
        cashFlowDto.setWriteOffItemList((List)Lists.newArrayList(itemCashMap.values()));
        cashFlowDto.setCustomerCode(dto.getCustomerCode());
        cashFlowDto.setOperateAmount(writeOffEntity.getWriteOffAmount());
        cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
        cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
        cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
        cashFlowDto.setAdjustTypeName(adjustType.getValue());
        CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
        writeOffEntity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
        this.creditWriteOffRepository.save((Object)writeOffEntity);
        writeOffItemEntities.forEach(creditWriteOffItemEntity -> creditWriteOffItemEntity.setWriteOffId(writeOffEntity.getId()));
        this.creditWriteOffItemRepository.saveBatch(writeOffItemEntities);
    }

    private List<CreditWriteOffItemEntity> buildCreditWriteOffItem(Map<String, CreditCashEntity> cashEntityMap, List<CreditWriteOffOrderDto> orderDtoList, List<CreditEntity> list) {
        ArrayList writeOffItemEntities = Lists.newArrayList();
        block0: for (CreditEntity creditEntity : list) {
            CreditCashEntity cashEntity = cashEntityMap.get(creditEntity.getId());
            Validate.notNull((Object)((Object)cashEntity), (String)"\u6388\u4fe1\u8d44\u91d1\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
            BigDecimal waitWriteOffAmount = cashEntity.getCreditAmount().subtract(cashEntity.getCanUseAmount()).subtract(cashEntity.getFreezeAmount());
            Validate.isTrue((waitWriteOffAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)String.format("\u6388\u4fe1\u4fe1\u606f[%s],\u5f85\u6838\u9500\u91d1\u989d\u4e3a0\u4e0d\u9700\u8981\u6838\u9500!", creditEntity.getCreditCode()), (Object[])new Object[0]);
            Iterator<CreditWriteOffOrderDto> iterator = orderDtoList.iterator();
            while (iterator.hasNext()) {
                CreditWriteOffOrderDto orderDto = iterator.next();
                CreditWriteOffItemEntity writeOffItemEntity = (CreditWriteOffItemEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderDto, CreditWriteOffItemEntity.class, HashSet.class, ArrayList.class, new String[0]));
                writeOffItemEntity.setId(null);
                writeOffItemEntity.setCreditId(creditEntity.getId());
                writeOffItemEntity.setOrderAmount(orderDto.getAmount());
                if (orderDto.getRemainAmount().compareTo(waitWriteOffAmount) > 0) {
                    orderDto.setRemainAmount(orderDto.getRemainAmount().subtract(waitWriteOffAmount));
                    writeOffItemEntity.setWriteOffItemAmount(waitWriteOffAmount);
                    writeOffItemEntities.add(writeOffItemEntity);
                    waitWriteOffAmount = BigDecimal.ZERO;
                } else {
                    waitWriteOffAmount = waitWriteOffAmount.subtract(orderDto.getRemainAmount());
                    writeOffItemEntity.setWriteOffItemAmount(orderDto.getRemainAmount());
                    writeOffItemEntities.add(writeOffItemEntity);
                    iterator.remove();
                }
                if (waitWriteOffAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                continue block0;
            }
        }
        Validate.isTrue((boolean)CollectionUtils.isEmpty(orderDtoList), (String)"\u5355\u636e\u603b\u91d1\u989d\u8d85\u51fa\u5f85\u6838\u9500\u603b\u91d1\u989d,\u65e0\u6cd5\u6838\u9500", (Object[])new Object[0]);
        return writeOffItemEntities;
    }

    private void createValidation(CreditWriteOffDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getWriteOffInfoList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6838\u9500\u8be6\u7ec6\u4fe1\u606f!", (Object[])new Object[0]);
        ArrayList orderCodes = Lists.newArrayList();
        dto.getWriteOffInfoList().forEach(infoDto -> {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)infoDto.getCreditIds()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6388\u4fe1ID!", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)infoDto.getOrderList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6838\u9500\u5355\u636e\u4fe1\u606f", (Object[])new Object[0]);
            infoDto.getOrderList().forEach(orderDto -> {
                Validate.notBlank((CharSequence)orderDto.getOrderType(), (String)"\u7f3a\u5931\u5355\u636e\u7c7b\u578b", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)orderDto.getOrderCode(), (String)"\u7f3a\u5931\u5355\u636e\u7f16\u7801", (Object[])new Object[0]);
                Validate.notNull((Object)orderDto.getAmount(), (String)"\u7f3a\u5931\u91d1\u989d", (Object[])new Object[0]);
                Validate.isTrue((orderDto.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u9700\u5927\u4e8e0", (Object[])new Object[0]);
                orderDto.setRemainAmount(orderDto.getAmount());
                orderDto.setTenantCode(dto.getTenantCode());
                orderCodes.add(orderDto.getOrderCode());
            });
        });
        List<CreditWriteOffItemEntity> itemEntities = this.creditWriteOffItemRepository.findByOrderCodes(orderCodes, dto.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(itemEntities), (String)String.format("\u5355\u636e[%s]\u5df2\u7ecf\u53c2\u4e0e\u8fc7\u6838\u9500,\u65e0\u6cd5\u7ee7\u7eed\u53c2\u4e0e\u6838\u9500", CollectionUtils.isEmpty(itemEntities) ? "" : itemEntities.get(0).getOrderCode()), (Object[])new Object[0]);
    }
}

