/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashVoService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditOccupyService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditPayService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditRefundService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditOccupyDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRefundDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCostPoolVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="CostPoolCreditStrategyImpl")
public class CostPoolCreditStrategyImpl
implements CostPoolStrategy {
    @Autowired(required=false)
    @Qualifier(value="CostPoolCreditRegisterImpl")
    private CostPoolRegister costPoolRegister;
    @Autowired(required=false)
    private CreditPayService creditPayService;
    @Autowired(required=false)
    private CreditRefundService creditRefundService;
    @Autowired(required=false)
    private CreditOccupyService creditOccupyService;
    @Autowired(required=false)
    private CreditCashVoService creditCashVoService;

    public String getPoolTypeRegisterKey() {
        return this.costPoolRegister.getKey();
    }

    public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
        if (Objects.isNull(costPoolDto) || StringUtils.isBlank((CharSequence)costPoolDto.getCustomerCode())) {
            return Lists.newLinkedList();
        }
        CreditCashModelDto modelDto = new CreditCashModelDto();
        modelDto.setCustomerCode(costPoolDto.getCustomerCode());
        modelDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        modelDto.setInEffectiveTime(Boolean.TRUE);
        Map<String, CreditCashVo> cashModelMap = this.creditCashVoService.findByCreditCashModelDto(modelDto);
        if (cashModelMap.isEmpty()) {
            return Lists.newLinkedList();
        }
        ArrayList creditCashList = Lists.newArrayList(cashModelMap.values());
        CreditCostPoolVo costPoolVo = new CreditCostPoolVo();
        costPoolVo.setCustomerCode(costPoolDto.getCustomerCode());
        costPoolVo.setFreezeAmount(BigDecimal.ZERO);
        costPoolVo.setHasUseAmount(BigDecimal.ZERO);
        costPoolVo.setTotalAmount(BigDecimal.ZERO);
        costPoolVo.setUsableAmount(BigDecimal.ZERO);
        creditCashList.forEach(creditCashVo -> {
            costPoolVo.setTotalAmount(costPoolVo.getTotalAmount().add(creditCashVo.getCreditAmount()));
            costPoolVo.setFreezeAmount(costPoolVo.getFreezeAmount().add(creditCashVo.getFreezeAmount()));
            costPoolVo.setHasUseAmount(costPoolVo.getHasUseAmount().add(creditCashVo.getHaveUseAmount()));
            costPoolVo.setUsableAmount(costPoolVo.getUsableAmount().add(creditCashVo.getCanUseAmount().compareTo(BigDecimal.ZERO) > 0 ? creditCashVo.getCanUseAmount() : BigDecimal.ZERO));
        });
        return Lists.newArrayList((Object[])new CostPoolVo[]{costPoolVo});
    }

    public void onHandleAdjust(JSONObject jsonObject) {
        Validate.notNull((Object)jsonObject, (String)"\u6388\u4fe1\u53d8\u66f4\u64cd\u4f5c\u65f6\u7f3a\u5931\u53c2\u6570\u5bf9\u8c61\uff01", (Object[])new Object[0]);
        String adjustTypeCode = jsonObject.getString("adjustTypeCode");
        Validate.notBlank((CharSequence)adjustTypeCode, (String)"\u6388\u4fe1\u53d8\u66f4\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CashAdjustTypeEnum adjustTypeEnum = CashAdjustTypeEnum.getByDictCode((String)adjustTypeCode);
        Validate.notNull((Object)adjustTypeEnum, (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u53d8\u66f4\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        switch (adjustTypeEnum) {
            case CREDIT_REDUCE: {
                CreditPayDto creditPayDto = (CreditPayDto)JsonUtils.json2Obj((String)jsonObject.toJSONString(), CreditPayDto.class);
                this.creditPayService.create(creditPayDto);
                break;
            }
            case CREDIT_RELEASE: {
                CreditRefundDto creditRefundDto = (CreditRefundDto)JsonUtils.json2Obj((String)jsonObject.toJSONString(), CreditRefundDto.class);
                this.creditRefundService.create(creditRefundDto);
                break;
            }
            case OCCUPY_USE: {
                CreditOccupyDto creditOccupyUseDto = (CreditOccupyDto)JsonUtils.json2Obj((String)jsonObject.toJSONString(), CreditOccupyDto.class);
                this.creditOccupyService.occupy(creditOccupyUseDto);
                break;
            }
            case OCCUPY_RELEASE: {
                CreditOccupyDto creditOccupyReleaseDto = (CreditOccupyDto)JsonUtils.json2Obj((String)jsonObject.toJSONString(), CreditOccupyDto.class);
                this.creditOccupyService.release(creditOccupyReleaseDto);
                break;
            }
        }
    }
}

