/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCreateCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CreditCreateCashFlowRegisterImpl
implements CreditCashFlowRegister<CreditCreateCashDto> {
    @Autowired(required=false)
    private CreditCashFlowItemRepository creditCashFlowItemRepository;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Class<CreditCreateCashDto> getClazz() {
        return CreditCreateCashDto.class;
    }

    @Transactional
    public List<CreditCashVo> onCreate(CreditCreateCashDto dto) {
        Validate.notBlank((CharSequence)dto.getCreditId(), (String)"\u7f3a\u5931\u6388\u4fe1ID", (Object[])new Object[0]);
        CreditCashEntity cashEntity = new CreditCashEntity();
        cashEntity.setCreditId(dto.getCreditId());
        cashEntity.setCreditType(dto.getCreditType());
        cashEntity.setCustomerCode(dto.getCustomerCode());
        cashEntity.setCanUseAmount(dto.getOperateAmount());
        cashEntity.setCreditAmount(dto.getOperateAmount());
        cashEntity.setFreezeAmount(BigDecimal.ZERO);
        cashEntity.setWriteOffAmount(BigDecimal.ZERO);
        cashEntity.setTenantCode(dto.getTenantCode());
        this.creditCashRepository.save((Object)cashEntity);
        CreditCashFlowItemEntity cashFlowItemEntity = new CreditCashFlowItemEntity();
        cashFlowItemEntity.setTenantCode(dto.getTenantCode());
        cashFlowItemEntity.setCreditId(dto.getCreditId());
        cashFlowItemEntity.setItemAmount(dto.getOperateAmount());
        cashFlowItemEntity.setCashFlowId(dto.getId());
        this.creditCashFlowItemRepository.save((Object)cashFlowItemEntity);
        return Lists.newArrayList((Object[])new CreditCashVo[]{(CreditCashVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)cashEntity, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0])});
    }

    public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
        return Lists.newLinkedList();
    }
}

