/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditOccupyEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditOccupyRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditOccupyCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.OccupyTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CreditOccupyCashFlowRegisterImpl
implements CreditCashFlowRegister<CreditOccupyCashDto> {
    @Autowired(required=false)
    private CreditCashVoService creditCashVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private CreditOccupyRepository creditOccupyRepository;
    @Autowired(required=false)
    private CreditCashFlowRepository creditCashFlowRepository;
    @Autowired(required=false)
    private CreditCashFlowItemRepository creditCashFlowItemRepository;

    public Class<CreditOccupyCashDto> getClazz() {
        return CreditOccupyCashDto.class;
    }

    @Transactional
    public List<CreditCashVo> onCreate(CreditOccupyCashDto dto) {
        Validate.notBlank((CharSequence)dto.getOccupyType(), (String)"\u5360\u7528\u6216\u91ca\u653e\u7c7b\u578b\u8bc6\u522b\u9519\u8bef\uff01", (Object[])new Object[0]);
        OccupyTypeEnum occupyTypeEnum = OccupyTypeEnum.getByDictCode((String)dto.getOccupyType());
        switch (occupyTypeEnum) {
            case OCCUPY: {
                return this.onOccupy(dto);
            }
            case RELEASE: {
                return this.onRelease(dto);
            }
        }
        return null;
    }

    public List<CreditCashVo> onOccupy(CreditOccupyCashDto dto) {
        Validate.isTrue((dto.getOperateAmount().compareTo(BigDecimal.ZERO) < 0 ? 1 : 0) != 0, (String)String.format("\u975e\u4e1a\u52a1\u8d44\u91d1\u6263\u51cf,\u65e0\u6cd5\u6267\u884c[%s]\u64cd\u4f5c", dto.getAdjustOperateName()), (Object[])new Object[0]);
        CreditCashModelDto modelDto = new CreditCashModelDto();
        modelDto.setCustomerCode(dto.getCustomerCode());
        modelDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        modelDto.setInEffectiveTime(Boolean.TRUE);
        Map<String, CreditCashVo> cashModelMap = this.creditCashVoService.findByCreditCashModelDto(modelDto);
        Validate.isTrue((cashModelMap != null && !cashModelMap.isEmpty() ? 1 : 0) != 0, (String)"\u6388\u4fe1\u8d44\u91d1\u5f02\u5e38!", (Object[])new Object[0]);
        List<CreditCashVo> cashModelList = cashModelMap.values().stream().sorted((o1, o2) -> {
            Long sortNum1 = CreditType.NORMAL_CREDIT.getDictCode().equals(o1.getCreditType()) ? 0L : o1.getCreditEndTime().getTime();
            Long sortNum2 = CreditType.NORMAL_CREDIT.getDictCode().equals(o2.getCreditType()) ? 0L : o2.getCreditEndTime().getTime();
            return sortNum2.compareTo(sortNum1);
        }).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(cashModelList) ? 1 : 0) != 0, (String)String.format("\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3,\u65e0\u6cd5\u6267\u884c[%s]\u64cd\u4f5c", dto.getAdjustOperateName()), (Object[])new Object[0]);
        List<CreditCashFlowItemEntity> itemEntities = this.buildCashFlowItemEntities(dto, cashModelList);
        List<CreditCashEntity> cashEntities = this.buildCashFlowItemEntities(cashModelMap, itemEntities);
        this.creditCashFlowItemRepository.saveBatch(itemEntities);
        this.creditCashRepository.updateBatchById(cashEntities);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(cashEntities, CreditCashEntity.class, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CreditCashVo> onRelease(CreditOccupyCashDto dto) {
        CreditOccupyEntity creditOccupyEntity = this.creditOccupyRepository.findOccupyByOccupyTypeAndBusinessOrderCode(TenantUtils.getTenantCode(), OccupyTypeEnum.OCCUPY, dto.getBusinessOrderCode());
        Validate.notNull((Object)((Object)creditOccupyEntity), (String)"\u672a\u627e\u5230\u6388\u4fe1\u5360\u7528\u4fe1\u606f\uff0c\u65e0\u6cd5\u6267\u884c\u91ca\u653e\u903b\u8f91\uff01", (Object[])new Object[0]);
        List<CreditCashFlowEntity> creditCashFlowEntities = this.creditCashFlowRepository.findByCashSerialNumbers(Collections.singletonList(creditOccupyEntity.getCashSerialNumber()), TenantUtils.getTenantCode());
        Validate.notEmpty(creditCashFlowEntities, (String)"\u672a\u627e\u5230\u6388\u4fe1\u5360\u7528\u8d44\u91d1\u6d41\u6c34\u4fe1\u606f\uff0c\u65e0\u6cd5\u6267\u884c\u91ca\u653e\u903b\u8f91\uff01", (Object[])new Object[0]);
        CreditCashFlowEntity creditCashFlowEntity = creditCashFlowEntities.get(0);
        List<CreditCashFlowItemEntity> creditCashFlowItemEntities = this.creditCashFlowItemRepository.findByCashFlowIds(Collections.singletonList(creditCashFlowEntity.getId()));
        Validate.notEmpty(creditCashFlowItemEntities, (String)"\u672a\u627e\u5230\u6388\u4fe1\u5360\u7528\u8d44\u91d1\u6d41\u6c34\u660e\u7ec6\uff0c\u65e0\u6cd5\u6267\u884c\u91ca\u653e\u903b\u8f91\uff01", (Object[])new Object[0]);
        List<String> creditIds = creditCashFlowItemEntities.stream().map(CreditCashFlowItemEntity::getCreditId).collect(Collectors.toList());
        List<CreditCashEntity> cashEntities = this.creditCashRepository.findByCreditIds(creditIds);
        Map<String, List<CreditCashFlowItemEntity>> creditCashFlowItemMap = creditCashFlowItemEntities.stream().collect(Collectors.groupingBy(CreditCashFlowItemEntity::getCreditId));
        cashEntities.forEach(cash -> {
            List itemEntities = (List)creditCashFlowItemMap.get(cash.getCreditId());
            if (CollectionUtils.isEmpty((Collection)itemEntities)) {
                return;
            }
            BigDecimal itemAmount = itemEntities.stream().map(CreditCashFlowItemEntity::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            cash.setOccupyAmount(cash.getOccupyAmount().add(itemAmount));
            cash.setCanUseAmount(cash.getCanUseAmount().subtract(itemAmount));
        });
        this.creditCashRepository.updateBatchById(cashEntities);
        creditCashFlowItemEntities.forEach(i -> {
            i.setId(null);
            i.setItemAmount(BigDecimal.ZERO.subtract(i.getItemAmount()));
        });
        this.creditCashFlowItemRepository.saveBatch(creditCashFlowItemEntities);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(cashEntities, CreditCashEntity.class, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CreditOccupyEntity> entities = this.creditOccupyRepository.findByCreditCashFlowExtendDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return entities.stream().map(entity -> {
            CreditCashFlowExtendVo extendVo = new CreditCashFlowExtendVo();
            extendVo.setCashSerialNumber(entity.getCashSerialNumber());
            extendVo.setOrderCode(entity.getBusinessOrderCode());
            extendVo.setRemark(entity.getRemark());
            extendVo.setOrderType(entity.getOrderType());
            return extendVo;
        }).collect(Collectors.toList());
    }

    private List<CreditCashEntity> buildCashFlowItemEntities(Map<String, CreditCashVo> cashModelMap, List<CreditCashFlowItemEntity> itemEntities) {
        return itemEntities.stream().map(creditCashFlowItemEntity -> {
            CreditCashVo cashVo = (CreditCashVo)cashModelMap.get(creditCashFlowItemEntity.getCreditId());
            CreditCashEntity cashEntity = (CreditCashEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)cashVo, CreditCashEntity.class, HashSet.class, ArrayList.class, new String[0])));
            cashEntity.setCanUseAmount(cashEntity.getCanUseAmount().add(creditCashFlowItemEntity.getItemAmount()));
            cashEntity.setOccupyAmount(cashEntity.getOccupyAmount().subtract(creditCashFlowItemEntity.getItemAmount()));
            return cashEntity;
        }).collect(Collectors.toList());
    }

    private List<CreditCashFlowItemEntity> buildCashFlowItemEntities(CreditOccupyCashDto dto, List<CreditCashVo> cashModelList) {
        ArrayList entities = Lists.newArrayList();
        BigDecimal waitAllotAmount = BigDecimal.ZERO.subtract(dto.getOperateAmount());
        for (CreditCashVo vo : cashModelList) {
            if (vo.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0 || waitAllotAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            CreditCashFlowItemEntity entity = new CreditCashFlowItemEntity();
            entity.setTenantCode(dto.getTenantCode());
            entity.setCreditId(vo.getCreditId());
            entity.setCashFlowId(dto.getId());
            entity.setItemAmount(waitAllotAmount.compareTo(vo.getCanUseAmount()) > 0 ? BigDecimal.ZERO.subtract(vo.getCanUseAmount()) : BigDecimal.ZERO.subtract(waitAllotAmount));
            entities.add(entity);
            waitAllotAmount = waitAllotAmount.add(entity.getItemAmount());
        }
        Validate.isTrue((waitAllotAmount.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)String.format("\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3,\u65e0\u6cd5\u6267\u884c[%s]\u64cd\u4f5c", dto.getAdjustOperateName()), (Object[])new Object[0]);
        return entities;
    }
}

