/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditPayEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditRefundEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditPayRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRefundRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.helper.CreditServiceHelper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRefundCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CreditRefundCashFlowRegisterImpl
implements CreditCashFlowRegister<CreditRefundCashDto> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditPayRepository creditPayRepository;
    @Autowired(required=false)
    private CreditRefundRepository creditRefundRepository;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private CreditCashFlowRepository creditCashFlowRepository;
    @Autowired(required=false)
    private CreditCashFlowItemRepository creditCashFlowItemRepository;
    @Autowired(required=false)
    private CreditServiceHelper creditServiceHelper;
    @Autowired(required=false)
    private CreditRepository creditRepository;

    public Class<CreditRefundCashDto> getClazz() {
        return CreditRefundCashDto.class;
    }

    @Transactional
    public List<CreditCashVo> onCreate(CreditRefundCashDto dto) {
        String tenantCode = TenantUtils.getTenantCode();
        CreditPayEntity payEntity = this.creditPayRepository.findByBusinessOrderCode(dto.getBusinessOrderCode(), tenantCode);
        Validate.notNull((Object)((Object)payEntity), (String)"\u5355\u636e\u5bf9\u5e94\u7684\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Map<String, BigDecimal> refundedMap = this.buildRefundedMap(dto.getBusinessOrderCode(), tenantCode);
        BigDecimal totalRefundedAmount = refundedMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((payEntity.getPayAmount().compareTo(dto.getOperateAmount().add(totalRefundedAmount)) >= 0 ? 1 : 0) != 0, (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5355\u636e\u652f\u4ed8\u91d1\u989d!", (Object[])new Object[0]);
        List<CreditCashFlowEntity> flowEntities = this.creditCashFlowRepository.findByCashSerialNumbers(Lists.newArrayList((Object[])new String[]{payEntity.getCashSerialNumber()}), tenantCode);
        Validate.isTrue((!CollectionUtils.isEmpty(flowEntities) && flowEntities.size() == 1 ? 1 : 0) != 0, (String)"\u5355\u636e\u652f\u4ed8\u6d41\u6c34\u83b7\u53d6\u5f02\u5e38!", (Object[])new Object[0]);
        List<CreditCashFlowItemEntity> flowItemEntities = this.creditCashFlowItemRepository.findByCashFlowIds(flowEntities.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        Validate.isTrue((!CollectionUtils.isEmpty(flowItemEntities) ? 1 : 0) != 0, (String)"\u5355\u636e\u652f\u4ed8\u6d41\u6c34\u660e\u7ec6\u83b7\u53d6\u5f02\u5e38!", (Object[])new Object[0]);
        List<CreditCashEntity> cashEntities = this.creditCashRepository.findByCreditIds(flowItemEntities.stream().map(CreditCashFlowItemEntity::getCreditId).collect(Collectors.toList()));
        Validate.isTrue((!CollectionUtils.isEmpty(cashEntities) ? 1 : 0) != 0, (String)"\u5355\u636e\u652f\u4ed8\u6388\u4fe1\u8d44\u91d1\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38!", (Object[])new Object[0]);
        this.saveCreditInfo(dto, flowItemEntities, cashEntities, refundedMap);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(cashEntities, CreditCashEntity.class, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void saveCreditInfo(CreditRefundCashDto dto, List<CreditCashFlowItemEntity> flowItemEntities, List<CreditCashEntity> cashEntities, Map<String, BigDecimal> refundedMap) {
        Map<String, CreditCashEntity> cashEntityMap = cashEntities.stream().collect(Collectors.toMap(CreditCashEntity::getCreditId, t -> t));
        ArrayList refundFlowItemEntities = Lists.newArrayList();
        BigDecimal remainRefundAmount = BigDecimal.valueOf(dto.getOperateAmount().doubleValue());
        for (CreditCashFlowItemEntity flowItemEntity : flowItemEntities) {
            BigDecimal refundAmount;
            if (remainRefundAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            CreditCashEntity cashEntity = cashEntityMap.get(flowItemEntity.getCreditId());
            Validate.notNull((Object)((Object)cashEntity), (String)"\u5355\u636e\u652f\u4ed8\u6388\u4fe1\u8d44\u91d1\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38!", (Object[])new Object[0]);
            BigDecimal payAmount = BigDecimal.ZERO.subtract(flowItemEntity.getItemAmount());
            BigDecimal refundedAmount = refundedMap.getOrDefault(flowItemEntity.getCreditId(), BigDecimal.ZERO);
            BigDecimal haveUseAmount = this.creditServiceHelper.calculateHaveUseAmount(cashEntity);
            BigDecimal canRefundAmount = payAmount.subtract(refundedAmount);
            BigDecimal bigDecimal = refundAmount = remainRefundAmount.compareTo(canRefundAmount) >= 0 ? canRefundAmount : remainRefundAmount;
            if (haveUseAmount.compareTo(refundAmount) < 0) {
                CreditEntity creditEntity = (CreditEntity)((Object)this.creditRepository.getById((Serializable)((Object)flowItemEntity.getCreditId())));
                throw new IllegalArgumentException(String.format("\u6388\u4fe1[%s]\u5df2\u4f7f\u7528\u91d1\u989d\u5c11\u4e8e\u9000\u6b3e\u91d1\u989d!", creditEntity.getCreditCode()));
            }
            cashEntity.setCanUseAmount(cashEntity.getCanUseAmount().add(refundAmount));
            CreditCashFlowItemEntity cashFlowItemEntity = new CreditCashFlowItemEntity();
            cashFlowItemEntity.setTenantCode(dto.getTenantCode());
            cashFlowItemEntity.setCreditId(flowItemEntity.getCreditId());
            cashFlowItemEntity.setItemAmount(refundAmount);
            cashFlowItemEntity.setCashFlowId(dto.getId());
            refundFlowItemEntities.add(cashFlowItemEntity);
            remainRefundAmount = remainRefundAmount.subtract(refundAmount);
        }
        Validate.isTrue((remainRefundAmount.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u5355\u636e\u652f\u4ed8\u9000\u6b3e\u91d1\u989d\u5f02\u5e38!", (Object[])new Object[0]);
        this.creditCashFlowItemRepository.saveBatch(refundFlowItemEntities);
        this.creditCashRepository.updateBatchById(cashEntities);
    }

    private Map<String, BigDecimal> buildRefundedMap(String businessOrderCode, String tenantCode) {
        Map<Object, Object> refundedMap = Maps.newHashMap();
        List<CreditRefundEntity> refundEntities = this.creditRefundRepository.findByBusinessOrderCode(businessOrderCode, tenantCode);
        if (CollectionUtils.isEmpty(refundEntities)) {
            return refundedMap;
        }
        List<String> cashSerialNumbers = refundEntities.stream().map(CreditRefundEntity::getCashSerialNumber).collect(Collectors.toList());
        List<CreditCashFlowEntity> flowEntities = this.creditCashFlowRepository.findByCashSerialNumbers(cashSerialNumbers, tenantCode);
        List<CreditCashFlowItemEntity> flowItemEntities = this.creditCashFlowItemRepository.findByCashFlowIds(flowEntities.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        Validate.isTrue((!CollectionUtils.isEmpty(flowItemEntities) ? 1 : 0) != 0, (String)"\u9000\u6b3e\u8d44\u91d1\u6d41\u6c34\u660e\u7ec6\u83b7\u53d6\u5f02\u5e38!", (Object[])new Object[0]);
        refundedMap = flowItemEntities.stream().collect(Collectors.toMap(CreditCashFlowItemEntity::getCreditId, CreditCashFlowItemEntity::getItemAmount, BigDecimal::add));
        return refundedMap;
    }

    public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CreditRefundEntity> entities = this.creditRefundRepository.findByCreditCashFlowExtendDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return entities.stream().map(entity -> {
            CreditCashFlowExtendVo extendVo = new CreditCashFlowExtendVo();
            extendVo.setCashSerialNumber(entity.getCashSerialNumber());
            extendVo.setRemark(entity.getRemark());
            extendVo.setOrderCode(entity.getBusinessOrderCode());
            extendVo.setOrderType(entity.getOrderType());
            return extendVo;
        }).collect(Collectors.toList());
    }
}

