package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowCustomerDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditCashFlowVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授信管理: CreditCashFlowVo: 授信资金流水
 *
 * @author ning.zhang
 * @date 2021/12/20
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/creditCashFlow")
@Api(tags = "授信管理: CreditCashFlowVo: 授信资金流水")
public class CreditCashFlowVoController {

  @Autowired(required = false)
  private CreditCashFlowVoService creditCashFlowVoService;

  /**
   * 授信资金流水分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditCashFlowVo>授信资金流水
   */
  @ApiOperation(value = "授信资金流水分页列表")
  @GetMapping("/findByConditions")
  public Result<Page<CreditCashFlowVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "CreditCashFlowPageDto", value = "分页Dto") CreditCashFlowPageDto dto) {
    try {
      return Result.ok(this.creditCashFlowVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-商城授信资金流水分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditCashFlowVo>授信资金流水
   */
  @ApiOperation(value = "客户-商城授信资金流水分页列表")
  @GetMapping("/findByCreditCashFlowCustomerDto")
  public Result<Page<CreditCashFlowVo>> findByCreditCashFlowCustomerDto(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "CreditCashFlowCustomerDto", value = "分页Dto") CreditCashFlowCustomerDto dto) {
    try {
      return Result.ok(this.creditCashFlowVoService.findByCreditCashFlowCustomerDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
