package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditCashStatsVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashStatsVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授信管理:  CreditCashStatsVo: 授信资金统计信息
 *
 * @author ning.zhang
 * @date 2021/12/31
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/creditCashStats")
@Api(tags = "授信管理:  CreditCashStatsVo: 授信资金统计信息")
public class CreditCashStatsVoController {

  @Autowired(required = false)
  private CreditCashStatsVoService creditCashStatsVoService;

  /**
   * 获取管理平台资金统计信息
   *
   * @return 资金统计信息
   */
  @ApiOperation(value = "获取管理平台资金统计信息")
  @GetMapping("findAll")
  public Result<CreditCashStatsVo> findAll() {
    try {
      return Result.ok(this.creditCashStatsVoService.findAll());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
