package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授信管理: CreditVo: 授信信息
 *
 * @author ning.zhang
 * @date 2021/12/20
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/credit")
@Api(tags = "授信管理: CreditVo: 授信信息")
public class CreditVoController {

  @Autowired(required = false)
  private CreditVoService creditVoService;

  /**
   * 普通授信信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 普通授信分页信息
   */
  @ApiOperation(value = "普通授信信息分页列表")
  @GetMapping("/findByCreditCommonPageDto")
  public Result<Page<CreditVo>> findByCreditCommonPageDto(@PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "CompanyInformationPageDto", value = "分页Dto") CreditPageDto dto) {
    try {
      return Result.ok(this.creditVoService.findByCreditCommonPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 临时授信信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 临时授信分页信息
   */
  @ApiOperation(value = "临时授信信息分页列表")
  @GetMapping("/findByCreditTemporaryPageDto")
  public Result<Page<CreditVo>> findByCreditTemporaryPageDto(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "CreditTemporaryPageDto", value = "分页Dto") CreditTemporaryPageDto dto) {
    try {
      return Result.ok(this.creditVoService.findByCreditTemporaryPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过普通授信ID获取授信信息
   *
   * @param commonCreditId 普通授信ID
   * @return 授信信息
   */
  @ApiOperation(value = "通过普通授信ID获取授信信息")
  @GetMapping("/findByCommonCreditId")
  public Result<CreditVo> findByCommonCreditId(@RequestParam(value = "commonCreditId", required = false) @ApiParam(name = "commonCreditId", value = "主键ID") String commonCreditId) {
    try {
      return Result.ok(this.creditVoService.findByCommonCreditId(commonCreditId));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过普通授信编码获取授信信息
   *
   * @param creditCode 普通授信编码
   * @return 授信信息
   */
  @ApiOperation(value = "通过普通授信编码获取授信信息")
  @GetMapping("/findByCreditCode")
    public Result<CreditVo> findByCreditCode(@RequestParam(value = "creditCode", required = false) @ApiParam(name = "creditCode", value = "编码") String creditCode) {
    try {
      return Result.ok(this.creditVoService.findByCreditCode(creditCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 临时授信ID获取授信信息
   *
   * @param creditTemporaryId 普通授信ID
   * @return 授信信息
   */
  @ApiOperation(value = "临时授信ID获取授信信息")
  @GetMapping("/findByCreditTemporaryId")
  public Result<CreditVo> findByCreditTemporaryId(@RequestParam(value = "creditTemporaryId", required = false)
                                                  @ApiParam(name = "creditTemporaryId", value = "主键ID") String creditTemporaryId) {
    try {
      return Result.ok(this.creditVoService.findByCreditTemporaryId(creditTemporaryId));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 临时授信编码获取授信信息
   *
   * @param creditTemporaryCode
   * @return 授信信息
   */
  @ApiOperation(value = "临时授信编码获取授信信息")
  @GetMapping("/findByCreditTemporaryCode")
  public Result<CreditVo> findByCreditTemporaryCode(@RequestParam(value = "creditTemporaryCode", required = false)
                                                  @ApiParam(name = "creditTemporaryCode", value = "授信编码") String creditTemporaryCode) {
    try {
      return Result.ok(this.creditVoService.findByCreditTemporaryCode(creditTemporaryCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-商城授信头展示查询
   * @param dto
   * @return
   */
  @ApiOperation(value = "客户-商城授信头展示查询")
  @GetMapping("/findByTotalCreditDto")
  public Result<CreditVo> findByTotalCreditDto(@ApiParam(name = "CreditDto", value = "Dto") CreditDto dto) {
    try {
      return Result.ok(this.creditVoService.findByTotalCreditDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 商城-临时授信申请记录信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 商城-临时授信申请记录信息分页列表
   */
  @ApiOperation(value = "商城-客户临时授信申请记录信息分页列表")
  @GetMapping("/findApplyRecordByCreditTemporaryPageDto")
  public Result<Page<CreditVo>> findApplyRecordByCreditTemporaryPageDto(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "CreditTemporaryPageDto", value = "分页Dto") CreditTemporaryPageDto dto) {
    try {
      return Result.ok(this.creditVoService.findApplyRecordByCreditTemporaryPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 商城-临时授信记录信息分页列表（审批通过）
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 商城-临时授信记录信息分页列表
   */
  @ApiOperation(value = "商城-客户临时授信记录信息分页列表")
  @GetMapping("/findRecordByCreditTemporaryPageDto")
  public Result<Page<CreditVo>> findRecordByCreditTemporaryPageDto(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "CreditTemporaryPageDto", value = "分页Dto") CreditTemporaryPageDto dto) {
    try {
      return Result.ok(this.creditVoService.findRecordByCreditTemporaryPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
